@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cloudServiceConfiguration This property and virtualMachineConfiguration are mutually exclusive and one of the properties must be specified. This property cannot be specified if the Batch account was created with its poolAllocationMode property set to 'UserSubscription'.
 * @property virtualMachineConfiguration This property and cloudServiceConfiguration are mutually exclusive and one of the properties must be specified.
 */
public data class DeploymentConfigurationResponse(
    public val cloudServiceConfiguration: CloudServiceConfigurationResponse? = null,
    public val virtualMachineConfiguration: VirtualMachineConfigurationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.DeploymentConfigurationResponse):
            DeploymentConfigurationResponse = DeploymentConfigurationResponse(
            cloudServiceConfiguration = javaType.cloudServiceConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.CloudServiceConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualMachineConfiguration = javaType.virtualMachineConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.VirtualMachineConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
