@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Network access profile for Batch endpoint.
 * @property defaultAction Default action for endpoint access. It is only applicable when publicNetworkAccess is enabled.
 * @property ipRules Array of IP ranges to filter client IP address.
 */
public data class EndpointAccessProfileResponse(
    public val defaultAction: String,
    public val ipRules: List<IPRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.EndpointAccessProfileResponse):
            EndpointAccessProfileResponse = EndpointAccessProfileResponse(
            defaultAction = javaType.defaultAction(),
            ipRules = javaType.ipRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.IPRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
