@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The network configuration for a pool.
 * @property dynamicVnetAssignmentScope
 * @property enableAcceleratedNetworking Accelerated networking enables single root I/O virtualization (SR-IOV) to a VM, which may lead to improved networking performance. For more details, see: https://learn.microsoft.com/azure/virtual-network/accelerated-networking-overview.
 * @property endpointConfiguration Pool endpoint configuration is only supported on pools with the virtualMachineConfiguration property.
 * @property publicIPAddressConfiguration This property is only supported on Pools with the virtualMachineConfiguration property.
 * @property subnetId The virtual network must be in the same region and subscription as the Azure Batch account. The specified subnet should have enough free IP addresses to accommodate the number of nodes in the pool. If the subnet doesn't have enough free IP addresses, the pool will partially allocate compute nodes and a resize error will occur. The 'MicrosoftAzureBatch' service principal must have the 'Classic Virtual Machine Contributor' Role-Based Access Control (RBAC) role for the specified VNet. The specified subnet must allow communication from the Azure Batch service to be able to schedule tasks on the compute nodes. This can be verified by checking if the specified VNet has any associated Network Security Groups (NSG). If communication to the compute nodes in the specified subnet is denied by an NSG, then the Batch service will set the state of the compute nodes to unusable. If the specified VNet has any associated Network Security Groups (NSG), then a few reserved system ports must be enabled for inbound communication. For pools created with a virtual machine configuration, enable ports 29876 and 29877, as well as port 22 for Linux and port 3389 for Windows. For pools created with a cloud service configuration, enable ports 10100, 20100, and 30100. Also enable outbound connections to Azure Storage on port 443. For cloudServiceConfiguration pools, only 'classic' VNETs are supported. For more details see: https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
 */
public data class NetworkConfigurationResponse(
    public val dynamicVnetAssignmentScope: String? = null,
    public val enableAcceleratedNetworking: Boolean? = null,
    public val endpointConfiguration: PoolEndpointConfigurationResponse? = null,
    public val publicIPAddressConfiguration: PublicIPAddressConfigurationResponse? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.NetworkConfigurationResponse):
            NetworkConfigurationResponse = NetworkConfigurationResponse(
            dynamicVnetAssignmentScope = javaType.dynamicVnetAssignmentScope().map({ args0 ->
                args0
            }).orElse(null),
            enableAcceleratedNetworking = javaType.enableAcceleratedNetworking().map({ args0 ->
                args0
            }).orElse(null),
            endpointConfiguration = javaType.endpointConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.PoolEndpointConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            publicIPAddressConfiguration = javaType.publicIPAddressConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.PublicIPAddressConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
