@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Contains information about a private link resource.
 * @property etag The ETag of the resource, used for concurrency statements.
 * @property groupIds The value has one and only one group id.
 * @property id The ID of the resource.
 * @property name The name of the resource.
 * @property privateEndpoint The private endpoint of the private endpoint connection.
 * @property privateLinkServiceConnectionState The private link service connection state of the private endpoint connection
 * @property provisioningState
 * @property type The type of the resource.
 */
public data class PrivateEndpointConnectionResponse(
    public val etag: String,
    public val groupIds: List<String>,
    public val id: String,
    public val name: String,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.PrivateEndpointConnectionResponse):
            PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            etag = javaType.etag(),
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.batch.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
