@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes either the current operation (if the pool AllocationState is Resizing) or the previously completed operation (if the AllocationState is Steady).
 * @property errors This property is set only if an error occurred during the last pool resize, and only when the pool allocationState is Steady.
 * @property nodeDeallocationOption The default value is requeue.
 * @property resizeTimeout The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request).
 * @property startTime
 * @property targetDedicatedNodes
 * @property targetLowPriorityNodes
 */
public data class ResizeOperationStatusResponse(
    public val errors: List<ResizeErrorResponse>? = null,
    public val nodeDeallocationOption: String? = null,
    public val resizeTimeout: String? = null,
    public val startTime: String? = null,
    public val targetDedicatedNodes: Int? = null,
    public val targetLowPriorityNodes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.ResizeOperationStatusResponse):
            ResizeOperationStatusResponse = ResizeOperationStatusResponse(
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ResizeErrorResponse.Companion.toKotlin(args0)
                })
            }),
            nodeDeallocationOption = javaType.nodeDeallocationOption().map({ args0 -> args0 }).orElse(null),
            resizeTimeout = javaType.resizeTimeout().map({ args0 -> args0 }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            targetDedicatedNodes = javaType.targetDedicatedNodes().map({ args0 -> args0 }).orElse(null),
            targetLowPriorityNodes = javaType.targetLowPriorityNodes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
