@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * In some cases the start task may be re-run even though the node was not rebooted. Due to this, start tasks should be idempotent and exit gracefully if the setup they're performing has already been done. Special care should be taken to avoid start tasks which create breakaway process or install/launch services from the start task working directory, as this will block Batch from being able to re-run the start task.
 * @property commandLine The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any other properties of the startTask are specified.
 * @property containerSettings When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all task environment variables are mapped into the container, and the task command line is executed in the container.
 * @property environmentSettings
 * @property maxTaskRetryCount The Batch service retries a task if its exit code is nonzero. Note that this value specifically controls the number of retries. The Batch service will try the task once, and may then retry up to this limit. For example, if the maximum retry count is 3, Batch tries the task up to 4 times (one initial try and 3 retries). If the maximum retry count is 0, the Batch service does not retry the task. If the maximum retry count is -1, the Batch service retries the task without limit. Default is 0.
 * @property resourceFiles
 * @property userIdentity If omitted, the task runs as a non-administrative user unique to the task.
 * @property waitForSuccess If true and the start task fails on a compute node, the Batch service retries the start task up to its maximum retry count (maxTaskRetryCount). If the task has still not completed successfully after all retries, then the Batch service marks the compute node unusable, and will not schedule tasks to it. This condition can be detected via the node state and scheduling error detail. If false, the Batch service will not wait for the start task to complete. In this case, other tasks can start executing on the compute node while the start task is still running; and even if the start task fails, new tasks will continue to be scheduled on the node. The default is true.
 */
public data class StartTaskResponse(
    public val commandLine: String? = null,
    public val containerSettings: TaskContainerSettingsResponse? = null,
    public val environmentSettings: List<EnvironmentSettingResponse>? = null,
    public val maxTaskRetryCount: Int? = null,
    public val resourceFiles: List<ResourceFileResponse>? = null,
    public val userIdentity: UserIdentityResponse? = null,
    public val waitForSuccess: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.StartTaskResponse):
            StartTaskResponse = StartTaskResponse(
            commandLine = javaType.commandLine().map({ args0 -> args0 }).orElse(null),
            containerSettings = javaType.containerSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.TaskContainerSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentSettings = javaType.environmentSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.EnvironmentSettingResponse.Companion.toKotlin(args0)
                })
            }),
            maxTaskRetryCount = javaType.maxTaskRetryCount().map({ args0 -> args0 }).orElse(null),
            resourceFiles = javaType.resourceFiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ResourceFileResponse.Companion.toKotlin(args0)
                })
            }),
            userIdentity = javaType.userIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.UserIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            waitForSuccess = javaType.waitForSuccess().map({ args0 -> args0 }).orElse(null),
        )
    }
}
