@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerRunOptions These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service.
 * @property imageName This is the full image reference, as would be specified to "docker pull". If no tag is provided as part of the image name, the tag ":latest" is used as a default.
 * @property registry This setting can be omitted if was already provided at pool creation.
 * @property workingDirectory
 */
public data class TaskContainerSettingsResponse(
    public val containerRunOptions: String? = null,
    public val imageName: String,
    public val registry: ContainerRegistryResponse? = null,
    public val workingDirectory: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.TaskContainerSettingsResponse):
            TaskContainerSettingsResponse = TaskContainerSettingsResponse(
            containerRunOptions = javaType.containerRunOptions().map({ args0 -> args0 }).orElse(null),
            imageName = javaType.imageName(),
            registry = javaType.registry().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.ContainerRegistryResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workingDirectory = javaType.workingDirectory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
