@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The list of associated user identities.
 * @property clientId The client id of user assigned identity.
 * @property principalId The principal id of user assigned identity.
 */
public data class UserAssignedIdentitiesResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.UserAssignedIdentitiesResponse):
            UserAssignedIdentitiesResponse = UserAssignedIdentitiesResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
