@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.batch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Specify either the userName or autoUser property, but not both.
 * @property autoUser The userName and autoUser properties are mutually exclusive; you must specify one but not both.
 * @property userName The userName and autoUser properties are mutually exclusive; you must specify one but not both.
 */
public data class UserIdentityResponse(
    public val autoUser: AutoUserSpecificationResponse? = null,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.batch.outputs.UserIdentityResponse):
            UserIdentityResponse = UserIdentityResponse(
            autoUser = javaType.autoUser().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.batch.kotlin.outputs.AutoUserSpecificationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
