@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.billing.kotlin

import com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The role assignment
 * Azure REST API version: 2019-10-01-preview. Prior API version in Azure Native 1.x: 2019-10-01-preview.
 * ## Example Usage
 * ### PutEnrollmentDepartmentAdministratorRoleAssignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var billingRoleAssignmentByDepartment = new AzureNative.Billing.BillingRoleAssignmentByDepartment("billingRoleAssignmentByDepartment", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingRoleAssignmentName = "{billingRoleAssignmentName}",
 *         DepartmentName = "{departmentName}",
 *         PrincipalId = "99a1a759-30dd-42c2-828c-db398826bb67",
 *         PrincipalTenantId = "7ca289b9-c32d-4f01-8566-7ff93261d76f",
 *         RoleDefinitionId = "/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/billing/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := billing.NewBillingRoleAssignmentByDepartment(ctx, "billingRoleAssignmentByDepartment", &billing.BillingRoleAssignmentByDepartmentArgs{
 * 			BillingAccountName:        pulumi.String("{billingAccountName}"),
 * 			BillingRoleAssignmentName: pulumi.String("{billingRoleAssignmentName}"),
 * 			DepartmentName:            pulumi.String("{departmentName}"),
 * 			PrincipalId:               pulumi.String("99a1a759-30dd-42c2-828c-db398826bb67"),
 * 			PrincipalTenantId:         pulumi.String("7ca289b9-c32d-4f01-8566-7ff93261d76f"),
 * 			RoleDefinitionId:          pulumi.String("/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartment;
 * import com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var billingRoleAssignmentByDepartment = new BillingRoleAssignmentByDepartment("billingRoleAssignmentByDepartment", BillingRoleAssignmentByDepartmentArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingRoleAssignmentName("{billingRoleAssignmentName}")
 *             .departmentName("{departmentName}")
 *             .principalId("99a1a759-30dd-42c2-828c-db398826bb67")
 *             .principalTenantId("7ca289b9-c32d-4f01-8566-7ff93261d76f")
 *             .roleDefinitionId("/providers/Microsoft.Billing/billingAccounts/7898901/departments/97603/billingRoleDefinitions/fb2cf67f-be5b-42e7-8025-4683c668f840")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:billing:BillingRoleAssignmentByDepartment 9dfd08c2-62a3-4d47-85bd-1cdba1408402 /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/departments/{departmentName}/billingRoleAssignments/{billingRoleAssignmentName}
 * ```
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingRoleAssignmentName The ID that uniquely identifies a role assignment.
 * @property departmentName The ID that uniquely identifies a department.
 * @property principalId The principal id of the user to whom the role was assigned.
 * @property principalTenantId The principal tenant id of the user to whom the role was assigned.
 * @property roleDefinitionId The ID of the role definition.
 * @property userAuthenticationType The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 * @property userEmailAddress The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
 */
public data class BillingRoleAssignmentByDepartmentArgs(
    public val billingAccountName: Output<String>? = null,
    public val billingRoleAssignmentName: Output<String>? = null,
    public val departmentName: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalTenantId: Output<String>? = null,
    public val roleDefinitionId: Output<String>? = null,
    public val userAuthenticationType: Output<String>? = null,
    public val userEmailAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs> {
    override fun toJava(): com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs =
        com.pulumi.azurenative.billing.BillingRoleAssignmentByDepartmentArgs.builder()
            .billingAccountName(billingAccountName?.applyValue({ args0 -> args0 }))
            .billingRoleAssignmentName(billingRoleAssignmentName?.applyValue({ args0 -> args0 }))
            .departmentName(departmentName?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalTenantId(principalTenantId?.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId?.applyValue({ args0 -> args0 }))
            .userAuthenticationType(userAuthenticationType?.applyValue({ args0 -> args0 }))
            .userEmailAddress(userEmailAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BillingRoleAssignmentByDepartmentArgs].
 */
@PulumiTagMarker
public class BillingRoleAssignmentByDepartmentArgsBuilder internal constructor() {
    private var billingAccountName: Output<String>? = null

    private var billingRoleAssignmentName: Output<String>? = null

    private var departmentName: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalTenantId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    private var userAuthenticationType: Output<String>? = null

    private var userEmailAddress: Output<String>? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("dmqoapyapclnibfc")
    public suspend fun billingAccountName(`value`: Output<String>) {
        this.billingAccountName = value
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("cxnitwxotmsjxgux")
    public suspend fun billingRoleAssignmentName(`value`: Output<String>) {
        this.billingRoleAssignmentName = value
    }

    /**
     * @param value The ID that uniquely identifies a department.
     */
    @JvmName("obxitbgufphjqhjy")
    public suspend fun departmentName(`value`: Output<String>) {
        this.departmentName = value
    }

    /**
     * @param value The principal id of the user to whom the role was assigned.
     */
    @JvmName("spbofpdoelmqahux")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The principal tenant id of the user to whom the role was assigned.
     */
    @JvmName("upoevpdvapenpwcc")
    public suspend fun principalTenantId(`value`: Output<String>) {
        this.principalTenantId = value
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("phybktfnfpecbdxl")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("xdlrlxptdxtyhjua")
    public suspend fun userAuthenticationType(`value`: Output<String>) {
        this.userAuthenticationType = value
    }

    /**
     * @param value The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("vqarnkddoysrxsgd")
    public suspend fun userEmailAddress(`value`: Output<String>) {
        this.userEmailAddress = value
    }

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("xjgxoqlrhogenhmf")
    public suspend fun billingAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a role assignment.
     */
    @JvmName("sqdlbqexxxeicwed")
    public suspend fun billingRoleAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingRoleAssignmentName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a department.
     */
    @JvmName("bkjvptoeehmfkfbt")
    public suspend fun departmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.departmentName = mapped
    }

    /**
     * @param value The principal id of the user to whom the role was assigned.
     */
    @JvmName("hroktthhkyerltem")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The principal tenant id of the user to whom the role was assigned.
     */
    @JvmName("svqsimqaxnihunvy")
    public suspend fun principalTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalTenantId = mapped
    }

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("yqbvlbjjakoumqgp")
    public suspend fun roleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The authentication type of the user, whether Organization or MSA, of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("aspdbvbxwhwxbsar")
    public suspend fun userAuthenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthenticationType = mapped
    }

    /**
     * @param value The email address of the user to whom the role was assigned. This is supported only for billing accounts with agreement type Enterprise Agreement.
     */
    @JvmName("xdjhbbulofjipwks")
    public suspend fun userEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEmailAddress = mapped
    }

    internal fun build(): BillingRoleAssignmentByDepartmentArgs =
        BillingRoleAssignmentByDepartmentArgs(
            billingAccountName = billingAccountName,
            billingRoleAssignmentName = billingRoleAssignmentName,
            departmentName = departmentName,
            principalId = principalId,
            principalTenantId = principalTenantId,
            roleDefinitionId = roleDefinitionId,
            userAuthenticationType = userAuthenticationType,
            userEmailAddress = userEmailAddress,
        )
}
