@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin

import com.pulumi.azurenative.blockchain.kotlin.outputs.BlockchainMemberNodesSkuResponse
import com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse
import com.pulumi.azurenative.blockchain.kotlin.outputs.SkuResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.blockchain.kotlin.outputs.BlockchainMemberNodesSkuResponse.Companion.toKotlin as blockchainMemberNodesSkuResponseToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin as firewallRuleResponseToKotlin
import com.pulumi.azurenative.blockchain.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin

/**
 * Builder for [BlockchainMember].
 */
@PulumiTagMarker
public class BlockchainMemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BlockchainMemberArgs = BlockchainMemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BlockchainMemberArgsBuilder.() -> Unit) {
        val builder = BlockchainMemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BlockchainMember {
        val builtJavaResource =
            com.pulumi.azurenative.blockchain.BlockchainMember(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BlockchainMember(builtJavaResource)
    }
}

/**
 * Payload of the blockchain member which is exposed in the request/response of the resource provider.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### BlockchainMembers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blockchainMember = new AzureNative.Blockchain.BlockchainMember("blockchainMember", new()
 *     {
 *         BlockchainMemberName = "contosemember1",
 *         Consortium = "ContoseConsortium",
 *         ConsortiumManagementAccountPassword = "<consortiumManagementAccountPassword>",
 *         Location = "southeastasia",
 *         Password = "<password>",
 *         Protocol = "Quorum",
 *         ResourceGroupName = "mygroup",
 *         ValidatorNodesSku = new AzureNative.Blockchain.Inputs.BlockchainMemberNodesSkuArgs
 *         {
 *             Capacity = 2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blockchain/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blockchain.NewBlockchainMember(ctx, "blockchainMember", &blockchain.BlockchainMemberArgs{
 * 			BlockchainMemberName:                pulumi.String("contosemember1"),
 * 			Consortium:                          pulumi.String("ContoseConsortium"),
 * 			ConsortiumManagementAccountPassword: pulumi.String("<consortiumManagementAccountPassword>"),
 * 			Location:                            pulumi.String("southeastasia"),
 * 			Password:                            pulumi.String("<password>"),
 * 			Protocol:                            pulumi.String("Quorum"),
 * 			ResourceGroupName:                   pulumi.String("mygroup"),
 * 			ValidatorNodesSku: &blockchain.BlockchainMemberNodesSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blockchain.BlockchainMember;
 * import com.pulumi.azurenative.blockchain.BlockchainMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blockchainMember = new BlockchainMember("blockchainMember", BlockchainMemberArgs.builder()
 *             .blockchainMemberName("contosemember1")
 *             .consortium("ContoseConsortium")
 *             .consortiumManagementAccountPassword("<consortiumManagementAccountPassword>")
 *             .location("southeastasia")
 *             .password("<password>")
 *             .protocol("Quorum")
 *             .resourceGroupName("mygroup")
 *             .validatorNodesSku(Map.of("capacity", 2))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blockchain:BlockchainMember contosemember1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}
 * ```
 */
public class BlockchainMember internal constructor(
    override val javaResource: com.pulumi.azurenative.blockchain.BlockchainMember,
) : KotlinCustomResource(javaResource, BlockchainMemberMapper) {
    /**
     * Gets or sets the consortium for the blockchain member.
     */
    public val consortium: Output<String>?
        get() = javaResource.consortium().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the managed consortium management account address.
     */
    public val consortiumManagementAccountAddress: Output<String>
        get() = javaResource.consortiumManagementAccountAddress().applyValue({ args0 -> args0 })

    /**
     * Sets the managed consortium management account password.
     */
    public val consortiumManagementAccountPassword: Output<String>?
        get() = javaResource.consortiumManagementAccountPassword().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Gets the display name of the member in the consortium.
     */
    public val consortiumMemberDisplayName: Output<String>?
        get() = javaResource.consortiumMemberDisplayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the role of the member in the consortium.
     */
    public val consortiumRole: Output<String>?
        get() = javaResource.consortiumRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the dns endpoint of the blockchain member.
     */
    public val dns: Output<String>
        get() = javaResource.dns().applyValue({ args0 -> args0 })

    /**
     * Gets or sets firewall rules
     */
    public val firewallRules: Output<List<FirewallRuleResponse>>?
        get() = javaResource.firewallRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        firewallRuleResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The GEO location of the blockchain service.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Sets the basic auth password of the blockchain member.
     */
    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the blockchain protocol.
     */
    public val protocol: Output<String>?
        get() = javaResource.protocol().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the blockchain member provision state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the public key of the blockchain member (default transaction node).
     */
    public val publicKey: Output<String>
        get() = javaResource.publicKey().applyValue({ args0 -> args0 })

    /**
     * Gets the Ethereum root contract address of the blockchain.
     */
    public val rootContractAddress: Output<String>
        get() = javaResource.rootContractAddress().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the blockchain member Sku.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags of the service which is a list of key value pairs that describes the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the service - e.g. "Microsoft.Blockchain"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the auth user name of the blockchain member.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the blockchain validator nodes Sku.
     */
    public val validatorNodesSku: Output<BlockchainMemberNodesSkuResponse>?
        get() = javaResource.validatorNodesSku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> blockchainMemberNodesSkuResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object BlockchainMemberMapper : ResourceMapper<BlockchainMember> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.blockchain.BlockchainMember::class == javaResource::class

    override fun map(javaResource: Resource): BlockchainMember = BlockchainMember(
        javaResource as
            com.pulumi.azurenative.blockchain.BlockchainMember,
    )
}

/**
 * @see [BlockchainMember].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BlockchainMember].
 */
public suspend fun blockchainMember(
    name: String,
    block: suspend BlockchainMemberResourceBuilder.() -> Unit,
): BlockchainMember {
    val builder = BlockchainMemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BlockchainMember].
 * @param name The _unique_ name of the resulting resource.
 */
public fun blockchainMember(name: String): BlockchainMember {
    val builder = BlockchainMemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
