@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin

import com.pulumi.azurenative.blockchain.BlockchainMemberArgs.builder
import com.pulumi.azurenative.blockchain.kotlin.enums.BlockchainProtocol
import com.pulumi.azurenative.blockchain.kotlin.inputs.BlockchainMemberNodesSkuArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.BlockchainMemberNodesSkuArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.FirewallRuleArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.FirewallRuleArgsBuilder
import com.pulumi.azurenative.blockchain.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.blockchain.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Payload of the blockchain member which is exposed in the request/response of the resource provider.
 * Azure REST API version: 2018-06-01-preview. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * ## Example Usage
 * ### BlockchainMembers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blockchainMember = new AzureNative.Blockchain.BlockchainMember("blockchainMember", new()
 *     {
 *         BlockchainMemberName = "contosemember1",
 *         Consortium = "ContoseConsortium",
 *         ConsortiumManagementAccountPassword = "<consortiumManagementAccountPassword>",
 *         Location = "southeastasia",
 *         Password = "<password>",
 *         Protocol = "Quorum",
 *         ResourceGroupName = "mygroup",
 *         ValidatorNodesSku = new AzureNative.Blockchain.Inputs.BlockchainMemberNodesSkuArgs
 *         {
 *             Capacity = 2,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blockchain/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blockchain.NewBlockchainMember(ctx, "blockchainMember", &blockchain.BlockchainMemberArgs{
 * 			BlockchainMemberName:                pulumi.String("contosemember1"),
 * 			Consortium:                          pulumi.String("ContoseConsortium"),
 * 			ConsortiumManagementAccountPassword: pulumi.String("<consortiumManagementAccountPassword>"),
 * 			Location:                            pulumi.String("southeastasia"),
 * 			Password:                            pulumi.String("<password>"),
 * 			Protocol:                            pulumi.String("Quorum"),
 * 			ResourceGroupName:                   pulumi.String("mygroup"),
 * 			ValidatorNodesSku: &blockchain.BlockchainMemberNodesSkuArgs{
 * 				Capacity: pulumi.Int(2),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blockchain.BlockchainMember;
 * import com.pulumi.azurenative.blockchain.BlockchainMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blockchainMember = new BlockchainMember("blockchainMember", BlockchainMemberArgs.builder()
 *             .blockchainMemberName("contosemember1")
 *             .consortium("ContoseConsortium")
 *             .consortiumManagementAccountPassword("<consortiumManagementAccountPassword>")
 *             .location("southeastasia")
 *             .password("<password>")
 *             .protocol("Quorum")
 *             .resourceGroupName("mygroup")
 *             .validatorNodesSku(Map.of("capacity", 2))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blockchain:BlockchainMember contosemember1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Blockchain/blockchainMembers/{blockchainMemberName}
 * ```
 * @property blockchainMemberName Blockchain member name.
 * @property consortium Gets or sets the consortium for the blockchain member.
 * @property consortiumManagementAccountPassword Sets the managed consortium management account password.
 * @property consortiumMemberDisplayName Gets the display name of the member in the consortium.
 * @property consortiumRole Gets the role of the member in the consortium.
 * @property firewallRules Gets or sets firewall rules
 * @property location The GEO location of the blockchain service.
 * @property password Sets the basic auth password of the blockchain member.
 * @property protocol Gets or sets the blockchain protocol.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sku Gets or sets the blockchain member Sku.
 * @property tags Tags of the service which is a list of key value pairs that describes the resource.
 * @property validatorNodesSku Gets or sets the blockchain validator nodes Sku.
 */
public data class BlockchainMemberArgs(
    public val blockchainMemberName: Output<String>? = null,
    public val consortium: Output<String>? = null,
    public val consortiumManagementAccountPassword: Output<String>? = null,
    public val consortiumMemberDisplayName: Output<String>? = null,
    public val consortiumRole: Output<String>? = null,
    public val firewallRules: Output<List<FirewallRuleArgs>>? = null,
    public val location: Output<String>? = null,
    public val password: Output<String>? = null,
    public val protocol: Output<Either<String, BlockchainProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validatorNodesSku: Output<BlockchainMemberNodesSkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.BlockchainMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.BlockchainMemberArgs =
        com.pulumi.azurenative.blockchain.BlockchainMemberArgs.builder()
            .blockchainMemberName(blockchainMemberName?.applyValue({ args0 -> args0 }))
            .consortium(consortium?.applyValue({ args0 -> args0 }))
            .consortiumManagementAccountPassword(
                consortiumManagementAccountPassword?.applyValue({ args0 ->
                    args0
                }),
            )
            .consortiumMemberDisplayName(consortiumMemberDisplayName?.applyValue({ args0 -> args0 }))
            .consortiumRole(consortiumRole?.applyValue({ args0 -> args0 }))
            .firewallRules(
                firewallRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validatorNodesSku(
                validatorNodesSku?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [BlockchainMemberArgs].
 */
@PulumiTagMarker
public class BlockchainMemberArgsBuilder internal constructor() {
    private var blockchainMemberName: Output<String>? = null

    private var consortium: Output<String>? = null

    private var consortiumManagementAccountPassword: Output<String>? = null

    private var consortiumMemberDisplayName: Output<String>? = null

    private var consortiumRole: Output<String>? = null

    private var firewallRules: Output<List<FirewallRuleArgs>>? = null

    private var location: Output<String>? = null

    private var password: Output<String>? = null

    private var protocol: Output<Either<String, BlockchainProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validatorNodesSku: Output<BlockchainMemberNodesSkuArgs>? = null

    /**
     * @param value Blockchain member name.
     */
    @JvmName("rvikknkipdyrjxbl")
    public suspend fun blockchainMemberName(`value`: Output<String>) {
        this.blockchainMemberName = value
    }

    /**
     * @param value Gets or sets the consortium for the blockchain member.
     */
    @JvmName("vrlsobmcfoamhtqf")
    public suspend fun consortium(`value`: Output<String>) {
        this.consortium = value
    }

    /**
     * @param value Sets the managed consortium management account password.
     */
    @JvmName("tmdhsljaghuhejax")
    public suspend fun consortiumManagementAccountPassword(`value`: Output<String>) {
        this.consortiumManagementAccountPassword = value
    }

    /**
     * @param value Gets the display name of the member in the consortium.
     */
    @JvmName("wtaqbalecxavmqur")
    public suspend fun consortiumMemberDisplayName(`value`: Output<String>) {
        this.consortiumMemberDisplayName = value
    }

    /**
     * @param value Gets the role of the member in the consortium.
     */
    @JvmName("spgnbkbiqchsnhud")
    public suspend fun consortiumRole(`value`: Output<String>) {
        this.consortiumRole = value
    }

    /**
     * @param value Gets or sets firewall rules
     */
    @JvmName("gpjfsqluexwpjmbq")
    public suspend fun firewallRules(`value`: Output<List<FirewallRuleArgs>>) {
        this.firewallRules = value
    }

    @JvmName("qwmmeuqdpkilkatt")
    public suspend fun firewallRules(vararg values: Output<FirewallRuleArgs>) {
        this.firewallRules = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets firewall rules
     */
    @JvmName("hdaylghkbclfbvyh")
    public suspend fun firewallRules(values: List<Output<FirewallRuleArgs>>) {
        this.firewallRules = Output.all(values)
    }

    /**
     * @param value The GEO location of the blockchain service.
     */
    @JvmName("gomoexnonmmbcvcr")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Sets the basic auth password of the blockchain member.
     */
    @JvmName("vdfpbvwpismcauxs")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Gets or sets the blockchain protocol.
     */
    @JvmName("nvgnwxmolkuwathj")
    public suspend fun protocol(`value`: Output<Either<String, BlockchainProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tiyfyousyoufvcnb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the blockchain member Sku.
     */
    @JvmName("lflkkajwvawqrjbm")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describes the resource.
     */
    @JvmName("axwtsyvcdeackaii")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the blockchain validator nodes Sku.
     */
    @JvmName("nfhqiabjumqnlhow")
    public suspend fun validatorNodesSku(`value`: Output<BlockchainMemberNodesSkuArgs>) {
        this.validatorNodesSku = value
    }

    /**
     * @param value Blockchain member name.
     */
    @JvmName("gamktojkiqckrwxl")
    public suspend fun blockchainMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockchainMemberName = mapped
    }

    /**
     * @param value Gets or sets the consortium for the blockchain member.
     */
    @JvmName("peiyvpqttagcapdp")
    public suspend fun consortium(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consortium = mapped
    }

    /**
     * @param value Sets the managed consortium management account password.
     */
    @JvmName("fmtfnnlhbjfsakbq")
    public suspend fun consortiumManagementAccountPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consortiumManagementAccountPassword = mapped
    }

    /**
     * @param value Gets the display name of the member in the consortium.
     */
    @JvmName("yynvemdrbaveqsls")
    public suspend fun consortiumMemberDisplayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consortiumMemberDisplayName = mapped
    }

    /**
     * @param value Gets the role of the member in the consortium.
     */
    @JvmName("smbxohlekqnffqpt")
    public suspend fun consortiumRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consortiumRole = mapped
    }

    /**
     * @param value Gets or sets firewall rules
     */
    @JvmName("devpdkgygyericoi")
    public suspend fun firewallRules(`value`: List<FirewallRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets firewall rules
     */
    @JvmName("lqblvdogoiodnura")
    public suspend fun firewallRules(argument: List<suspend FirewallRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets firewall rules
     */
    @JvmName("lfensfbjpcpbwcam")
    public suspend fun firewallRules(vararg argument: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param argument Gets or sets firewall rules
     */
    @JvmName("lqhupipyqxrvxvrc")
    public suspend fun firewallRules(argument: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FirewallRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.firewallRules = mapped
    }

    /**
     * @param values Gets or sets firewall rules
     */
    @JvmName("ajeutjuxmnrrvdhk")
    public suspend fun firewallRules(vararg values: FirewallRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.firewallRules = mapped
    }

    /**
     * @param value The GEO location of the blockchain service.
     */
    @JvmName("ywgmwisdqadsjlsn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Sets the basic auth password of the blockchain member.
     */
    @JvmName("hwfwxsuogswkymnu")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Gets or sets the blockchain protocol.
     */
    @JvmName("dudhoytgmpybfpxm")
    public suspend fun protocol(`value`: Either<String, BlockchainProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Gets or sets the blockchain protocol.
     */
    @JvmName("cwdhbamklpohhqip")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlockchainProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Gets or sets the blockchain protocol.
     */
    @JvmName("cgugtncceuwyjfee")
    public fun protocol(`value`: BlockchainProtocol) {
        val toBeMapped = Either.ofRight<String, BlockchainProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qaunlswkeyvyfkbj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the blockchain member Sku.
     */
    @JvmName("dovqmmthrkleyyxl")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the blockchain member Sku.
     */
    @JvmName("odifgjmakqafyrtg")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describes the resource.
     */
    @JvmName("vtdtqdskimakmvew")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the service which is a list of key value pairs that describes the resource.
     */
    @JvmName("ogldvknoxxswmlwm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the blockchain validator nodes Sku.
     */
    @JvmName("lsawdnldsxnmyavd")
    public suspend fun validatorNodesSku(`value`: BlockchainMemberNodesSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validatorNodesSku = mapped
    }

    /**
     * @param argument Gets or sets the blockchain validator nodes Sku.
     */
    @JvmName("tiflcelyexomsbqp")
    public suspend
    fun validatorNodesSku(argument: suspend BlockchainMemberNodesSkuArgsBuilder.() -> Unit) {
        val toBeMapped = BlockchainMemberNodesSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validatorNodesSku = mapped
    }

    internal fun build(): BlockchainMemberArgs = BlockchainMemberArgs(
        blockchainMemberName = blockchainMemberName,
        consortium = consortium,
        consortiumManagementAccountPassword = consortiumManagementAccountPassword,
        consortiumMemberDisplayName = consortiumMemberDisplayName,
        consortiumRole = consortiumRole,
        firewallRules = firewallRules,
        location = location,
        password = password,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        validatorNodesSku = validatorNodesSku,
    )
}
