@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.ListLocationConsortiumsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property locationName Location Name.
 */
public data class ListLocationConsortiumsPlainArgs(
    public val locationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.ListLocationConsortiumsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.inputs.ListLocationConsortiumsPlainArgs =
        com.pulumi.azurenative.blockchain.inputs.ListLocationConsortiumsPlainArgs.builder()
            .locationName(locationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListLocationConsortiumsPlainArgs].
 */
@PulumiTagMarker
public class ListLocationConsortiumsPlainArgsBuilder internal constructor() {
    private var locationName: String? = null

    /**
     * @param value Location Name.
     */
    @JvmName("ftawbjcisnmmtqmh")
    public suspend fun locationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.locationName = mapped
    }

    internal fun build(): ListLocationConsortiumsPlainArgs = ListLocationConsortiumsPlainArgs(
        locationName = locationName ?: throw PulumiNullFieldException("locationName"),
    )
}
