@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.inputs

import com.pulumi.azurenative.blockchain.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Blockchain member Sku in payload
 * @property name Gets or sets Sku name
 * @property tier Gets or sets Sku tier
 */
public data class SkuArgs(
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blockchain.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.blockchain.inputs.SkuArgs =
        com.pulumi.azurenative.blockchain.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Gets or sets Sku name
     */
    @JvmName("ftcbpxfodojuwkta")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets Sku tier
     */
    @JvmName("xaybtojmrahtondm")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Gets or sets Sku name
     */
    @JvmName("keodeactadholyhf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets Sku tier
     */
    @JvmName("xsfftaqnoymoygvp")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
        tier = tier,
    )
}
