@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * API key payload which is exposed in the request/response of the resource provider.
 * @property keyName Gets or sets the API key name.
 * @property value Gets or sets the API key value.
 */
public data class ApiKeyResponse(
    public val keyName: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.ApiKeyResponse):
            ApiKeyResponse = ApiKeyResponse(
            keyName = javaType.keyName().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
