@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Consortium payload
 * @property name Gets or sets the blockchain member name.
 * @property protocol Gets or sets the protocol for the consortium.
 */
public data class ConsortiumResponse(
    public val name: String? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.ConsortiumResponse):
            ConsortiumResponse = ConsortiumResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
