@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Ip range for firewall rules
 * @property endIpAddress Gets or sets the end IP address of the firewall rule range.
 * @property ruleName Gets or sets the name of the firewall rules.
 * @property startIpAddress Gets or sets the start IP address of the firewall rule range.
 */
public data class FirewallRuleResponse(
    public val endIpAddress: String? = null,
    public val ruleName: String? = null,
    public val startIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.FirewallRuleResponse):
            FirewallRuleResponse = FirewallRuleResponse(
            endIpAddress = javaType.endIpAddress().map({ args0 -> args0 }).orElse(null),
            ruleName = javaType.ruleName().map({ args0 -> args0 }).orElse(null),
            startIpAddress = javaType.startIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
