@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blockchain.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Payload of the blockchain member which is exposed in the request/response of the resource provider.
 * @property consortium Gets or sets the consortium for the blockchain member.
 * @property consortiumManagementAccountAddress Gets the managed consortium management account address.
 * @property consortiumManagementAccountPassword Sets the managed consortium management account password.
 * @property consortiumMemberDisplayName Gets the display name of the member in the consortium.
 * @property consortiumRole Gets the role of the member in the consortium.
 * @property dns Gets the dns endpoint of the blockchain member.
 * @property firewallRules Gets or sets firewall rules
 * @property id Fully qualified resource Id of the resource.
 * @property location The GEO location of the blockchain service.
 * @property name The name of the resource.
 * @property password Sets the basic auth password of the blockchain member.
 * @property protocol Gets or sets the blockchain protocol.
 * @property provisioningState Gets or sets the blockchain member provision state.
 * @property publicKey Gets the public key of the blockchain member (default transaction node).
 * @property rootContractAddress Gets the Ethereum root contract address of the blockchain.
 * @property sku Gets or sets the blockchain member Sku.
 * @property tags Tags of the service which is a list of key value pairs that describes the resource.
 * @property type The type of the service - e.g. "Microsoft.Blockchain"
 * @property userName Gets the auth user name of the blockchain member.
 * @property validatorNodesSku Gets or sets the blockchain validator nodes Sku.
 */
public data class GetBlockchainMemberResult(
    public val consortium: String? = null,
    public val consortiumManagementAccountAddress: String,
    public val consortiumManagementAccountPassword: String? = null,
    public val consortiumMemberDisplayName: String? = null,
    public val consortiumRole: String? = null,
    public val dns: String,
    public val firewallRules: List<FirewallRuleResponse>? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val password: String? = null,
    public val protocol: String? = null,
    public val provisioningState: String,
    public val publicKey: String,
    public val rootContractAddress: String,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val userName: String,
    public val validatorNodesSku: BlockchainMemberNodesSkuResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blockchain.outputs.GetBlockchainMemberResult):
            GetBlockchainMemberResult = GetBlockchainMemberResult(
            consortium = javaType.consortium().map({ args0 -> args0 }).orElse(null),
            consortiumManagementAccountAddress = javaType.consortiumManagementAccountAddress(),
            consortiumManagementAccountPassword = javaType.consortiumManagementAccountPassword().map({ args0 ->
                args0
            }).orElse(null),
            consortiumMemberDisplayName = javaType.consortiumMemberDisplayName().map({ args0 ->
                args0
            }).orElse(null),
            consortiumRole = javaType.consortiumRole().map({ args0 -> args0 }).orElse(null),
            dns = javaType.dns(),
            firewallRules = javaType.firewallRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blockchain.kotlin.outputs.FirewallRuleResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey(),
            rootContractAddress = javaType.rootContractAddress(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blockchain.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userName = javaType.userName(),
            validatorNodesSku = javaType.validatorNodesSku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.blockchain.kotlin.outputs.BlockchainMemberNodesSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
