@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin

import com.pulumi.azurenative.blueprint.BlueprintArgs.builder
import com.pulumi.azurenative.blueprint.kotlin.enums.BlueprintTargetScope
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterDefinitionArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ParameterDefinitionArgsBuilder
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupDefinitionArgs
import com.pulumi.azurenative.blueprint.kotlin.inputs.ResourceGroupDefinitionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a Blueprint definition.
 * Azure REST API version: 2018-11-01-preview. Prior API version in Azure Native 1.x: 2018-11-01-preview.
 * Other available API versions: 2017-11-11-preview.
 * ## Example Usage
 * ### ManagementGroupBlueprint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "blueprint contains all artifact kinds {'template', 'rbac', 'policy'}",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "force cost center tag for all resources under given subscription.",
 *                 Type = "string",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "assign owners to subscription along with blueprint assignment.",
 *                 Type = "array",
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "storage account type.",
 *                 Type = "string",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 Description = "Contains storageAccounts that collect all shoebox logs.",
 *                 DisplayName = "storage resource group",
 *             } },
 *         },
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup",
 *         TargetScope = "subscription",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
 * 			Parameters: blueprint.ParameterDefinitionMap{
 * 				"costCenter": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("force cost center tag for all resources under given subscription."),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 				"owners": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("assign owners to subscription along with blueprint assignment."),
 * 					Type:        pulumi.String("array"),
 * 				},
 * 				"storageAccountType": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("storage account type."),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"storageRG": &blueprint.ResourceGroupDefinitionArgs{
 * 					Description: pulumi.String("Contains storageAccounts that collect all shoebox logs."),
 * 					DisplayName: pulumi.String("storage resource group"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup"),
 * 			TargetScope:   pulumi.String("subscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.ofEntries(
 *                     Map.entry("displayName", "force cost center tag for all resources under given subscription."),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("owners", Map.ofEntries(
 *                     Map.entry("displayName", "assign owners to subscription along with blueprint assignment."),
 *                     Map.entry("type", "array")
 *                 )),
 *                 Map.entry("storageAccountType", Map.ofEntries(
 *                     Map.entry("displayName", "storage account type."),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("description", "Contains storageAccounts that collect all shoebox logs."),
 *                 Map.entry("displayName", "storage resource group")
 *             )))
 *             .resourceScope("providers/Microsoft.Management/managementGroups/ContosoOnlineGroup")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ### ResourceGroupWithTags
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "An example blueprint containing an RG with two tags.",
 *         ResourceGroups =
 *         {
 *             { "myRGName", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 DisplayName = "My Resource Group",
 *                 Location = "westus",
 *                 Name = "myRGName",
 *                 Tags =
 *                 {
 *                     { "costcenter", "123456" },
 *                     { "nameOnlyTag", "" },
 *                 },
 *             } },
 *         },
 *         ResourceScope = "providers/Microsoft.Management/managementGroups/{ManagementGroupId}",
 *         TargetScope = "subscription",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("An example blueprint containing an RG with two tags."),
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"myRGName": &blueprint.ResourceGroupDefinitionArgs{
 * 					DisplayName: pulumi.String("My Resource Group"),
 * 					Location:    pulumi.String("westus"),
 * 					Name:        pulumi.String("myRGName"),
 * 					Tags: pulumi.StringMap{
 * 						"costcenter":  pulumi.String("123456"),
 * 						"nameOnlyTag": pulumi.String(""),
 * 					},
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("providers/Microsoft.Management/managementGroups/{ManagementGroupId}"),
 * 			TargetScope:   pulumi.String("subscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("An example blueprint containing an RG with two tags.")
 *             .resourceGroups(Map.of("myRGName", Map.ofEntries(
 *                 Map.entry("displayName", "My Resource Group"),
 *                 Map.entry("location", "westus"),
 *                 Map.entry("name", "myRGName"),
 *                 Map.entry("tags", Map.ofEntries(
 *                     Map.entry("costcenter", "123456"),
 *                     Map.entry("nameOnlyTag", "")
 *                 ))
 *             )))
 *             .resourceScope("providers/Microsoft.Management/managementGroups/{ManagementGroupId}")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ### SubscriptionBlueprint
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blueprint = new AzureNative.Blueprint.Blueprint("blueprint", new()
 *     {
 *         BlueprintName = "simpleBlueprint",
 *         Description = "blueprint contains all artifact kinds {'template', 'rbac', 'policy'}",
 *         Parameters =
 *         {
 *             { "costCenter", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "force cost center tag for all resources under given subscription.",
 *                 Type = "string",
 *             } },
 *             { "owners", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "assign owners to subscription along with blueprint assignment.",
 *                 Type = "array",
 *             } },
 *             { "storageAccountType", new AzureNative.Blueprint.Inputs.ParameterDefinitionArgs
 *             {
 *                 DisplayName = "storage account type.",
 *                 Type = "string",
 *             } },
 *         },
 *         ResourceGroups =
 *         {
 *             { "storageRG", new AzureNative.Blueprint.Inputs.ResourceGroupDefinitionArgs
 *             {
 *                 Description = "Contains storageAccounts that collect all shoebox logs.",
 *                 DisplayName = "storage resource group",
 *             } },
 *         },
 *         ResourceScope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *         TargetScope = "subscription",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/blueprint/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := blueprint.NewBlueprint(ctx, "blueprint", &blueprint.BlueprintArgs{
 * 			BlueprintName: pulumi.String("simpleBlueprint"),
 * 			Description:   pulumi.String("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}"),
 * 			Parameters: blueprint.ParameterDefinitionMap{
 * 				"costCenter": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("force cost center tag for all resources under given subscription."),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 				"owners": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("assign owners to subscription along with blueprint assignment."),
 * 					Type:        pulumi.String("array"),
 * 				},
 * 				"storageAccountType": &blueprint.ParameterDefinitionArgs{
 * 					DisplayName: pulumi.String("storage account type."),
 * 					Type:        pulumi.String("string"),
 * 				},
 * 			},
 * 			ResourceGroups: blueprint.ResourceGroupDefinitionMap{
 * 				"storageRG": &blueprint.ResourceGroupDefinitionArgs{
 * 					Description: pulumi.String("Contains storageAccounts that collect all shoebox logs."),
 * 					DisplayName: pulumi.String("storage resource group"),
 * 				},
 * 			},
 * 			ResourceScope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 			TargetScope:   pulumi.String("subscription"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.blueprint.Blueprint;
 * import com.pulumi.azurenative.blueprint.BlueprintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blueprint = new Blueprint("blueprint", BlueprintArgs.builder()
 *             .blueprintName("simpleBlueprint")
 *             .description("blueprint contains all artifact kinds {'template', 'rbac', 'policy'}")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("costCenter", Map.ofEntries(
 *                     Map.entry("displayName", "force cost center tag for all resources under given subscription."),
 *                     Map.entry("type", "string")
 *                 )),
 *                 Map.entry("owners", Map.ofEntries(
 *                     Map.entry("displayName", "assign owners to subscription along with blueprint assignment."),
 *                     Map.entry("type", "array")
 *                 )),
 *                 Map.entry("storageAccountType", Map.ofEntries(
 *                     Map.entry("displayName", "storage account type."),
 *                     Map.entry("type", "string")
 *                 ))
 *             ))
 *             .resourceGroups(Map.of("storageRG", Map.ofEntries(
 *                 Map.entry("description", "Contains storageAccounts that collect all shoebox logs."),
 *                 Map.entry("displayName", "storage resource group")
 *             )))
 *             .resourceScope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .targetScope("subscription")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:blueprint:Blueprint simpleBlueprint /{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}
 * ```
 * @property blueprintName Name of the blueprint definition.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property parameters Parameters required by this blueprint definition.
 * @property resourceGroups Resource group placeholders defined by this blueprint definition.
 * @property resourceScope The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
 * @property targetScope The scope where this blueprint definition can be assigned.
 * @property versions Published versions of this blueprint definition.
 */
public data class BlueprintArgs(
    public val blueprintName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionArgs>>? = null,
    public val resourceGroups: Output<Map<String, ResourceGroupDefinitionArgs>>? = null,
    public val resourceScope: Output<String>? = null,
    public val targetScope: Output<Either<String, BlueprintTargetScope>>? = null,
    public val versions: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.blueprint.BlueprintArgs> {
    override fun toJava(): com.pulumi.azurenative.blueprint.BlueprintArgs =
        com.pulumi.azurenative.blueprint.BlueprintArgs.builder()
            .blueprintName(blueprintName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceGroups(
                resourceGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .resourceScope(resourceScope?.applyValue({ args0 -> args0 }))
            .targetScope(
                targetScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .versions(versions?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlueprintArgs].
 */
@PulumiTagMarker
public class BlueprintArgsBuilder internal constructor() {
    private var blueprintName: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var parameters: Output<Map<String, ParameterDefinitionArgs>>? = null

    private var resourceGroups: Output<Map<String, ResourceGroupDefinitionArgs>>? = null

    private var resourceScope: Output<String>? = null

    private var targetScope: Output<Either<String, BlueprintTargetScope>>? = null

    private var versions: Output<Any>? = null

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("aohwjfshtfrvgwxt")
    public suspend fun blueprintName(`value`: Output<String>) {
        this.blueprintName = value
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("pyfrynhqieeimphs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("knrbydcgaogagidy")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Parameters required by this blueprint definition.
     */
    @JvmName("kurxcsrgnnkcjdqd")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("uqhtgvqkeshbxyjk")
    public suspend fun resourceGroups(`value`: Output<Map<String, ResourceGroupDefinitionArgs>>) {
        this.resourceGroups = value
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("bhrpkvptuvtokpcy")
    public suspend fun resourceScope(`value`: Output<String>) {
        this.resourceScope = value
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("dklgqqwfeiralvhc")
    public suspend fun targetScope(`value`: Output<Either<String, BlueprintTargetScope>>) {
        this.targetScope = value
    }

    /**
     * @param value Published versions of this blueprint definition.
     */
    @JvmName("tjqyrxdwrkigxcfp")
    public suspend fun versions(`value`: Output<Any>) {
        this.versions = value
    }

    /**
     * @param value Name of the blueprint definition.
     */
    @JvmName("qfykdlykfocxhsvd")
    public suspend fun blueprintName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blueprintName = mapped
    }

    /**
     * @param value Multi-line explain this resource.
     */
    @JvmName("xblcfbrkskjikqvx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One-liner string explain this resource.
     */
    @JvmName("jqnnvdrrcoeoknqu")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Parameters required by this blueprint definition.
     */
    @JvmName("whrfqjawlrdaiouh")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters required by this blueprint definition.
     */
    @JvmName("kjdsblpmqpvagxcg")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters required by this blueprint definition.
     */
    @JvmName("htnchwdvknsidiat")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("mntvljuikpnpkowd")
    public suspend fun resourceGroups(`value`: Map<String, ResourceGroupDefinitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param argument Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("glcumumrqwxmkdir")
    public suspend fun resourceGroups(
        vararg
        argument: Pair<String, suspend ResourceGroupDefinitionArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ResourceGroupDefinitionArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.resourceGroups = mapped
    }

    /**
     * @param values Resource group placeholders defined by this blueprint definition.
     */
    @JvmName("xstxtjrnppujevys")
    public fun resourceGroups(vararg values: Pair<String, ResourceGroupDefinitionArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroups = mapped
    }

    /**
     * @param value The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}').
     */
    @JvmName("greadfyeaupucwkc")
    public suspend fun resourceScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("xeyubyileiwddbmo")
    public suspend fun targetScope(`value`: Either<String, BlueprintTargetScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("krjpdxgnudhkufts")
    public fun targetScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BlueprintTargetScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value The scope where this blueprint definition can be assigned.
     */
    @JvmName("ixjfvwuwuigjkcwh")
    public fun targetScope(`value`: BlueprintTargetScope) {
        val toBeMapped = Either.ofRight<String, BlueprintTargetScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetScope = mapped
    }

    /**
     * @param value Published versions of this blueprint definition.
     */
    @JvmName("pveyskswjypuvsdx")
    public suspend fun versions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versions = mapped
    }

    internal fun build(): BlueprintArgs = BlueprintArgs(
        blueprintName = blueprintName,
        description = description,
        displayName = displayName,
        parameters = parameters,
        resourceGroups = resourceGroups,
        resourceScope = resourceScope,
        targetScope = targetScope,
        versions = versions,
    )
}
