@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Blueprint artifact that applies a Role assignment.
 * @property dependsOn Artifacts which need to be deployed before the specified artifact.
 * @property description Multi-line explain this resource.
 * @property displayName One-liner string explain this resource.
 * @property id String Id used to locate any resource on Azure.
 * @property kind Specifies the kind of blueprint artifact.
 * Expected value is 'roleAssignment'.
 * @property name Name of this resource.
 * @property principalIds Array of user or group identities in Azure Active Directory. The roleDefinition will apply to each identity.
 * @property resourceGroup RoleAssignment will be scope to this resourceGroup. If empty, it scopes to the subscription.
 * @property roleDefinitionId Azure resource ID of the RoleDefinition.
 * @property type Type of this resource.
 */
public data class GetRoleAssignmentArtifactResult(
    public val dependsOn: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val principalIds: Any,
    public val resourceGroup: String? = null,
    public val roleDefinitionId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.GetRoleAssignmentArtifactResult):
            GetRoleAssignmentArtifactResult = GetRoleAssignmentArtifactResult(
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            principalIds = javaType.principalIds(),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            roleDefinitionId = javaType.roleDefinitionId(),
            type = javaType.type(),
        )
    }
}
