@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.blueprint.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Represents an Azure resource group in a blueprint definition.
 * @property dependsOn Artifacts which need to be deployed before this resource group.
 * @property description Description of this parameter/resourceGroup.
 * @property displayName DisplayName of this parameter/resourceGroup.
 * @property location Location of this resourceGroup. Leave empty if the resource group location will be specified during the blueprint assignment.
 * @property name Name of this resourceGroup. Leave empty if the resource group name will be specified during the blueprint assignment.
 * @property strongType StrongType for UI to render rich experience during blueprint assignment. Supported strong types are resourceType, principalId and location.
 * @property tags Tags to be assigned to this resource group.
 */
public data class ResourceGroupDefinitionResponse(
    public val dependsOn: List<String>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val location: String? = null,
    public val name: String? = null,
    public val strongType: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.blueprint.outputs.ResourceGroupDefinitionResponse):
            ResourceGroupDefinitionResponse = ResourceGroupDefinitionResponse(
            dependsOn = javaType.dependsOn().map({ args0 -> args0 }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            strongType = javaType.strongType().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
