@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin

import com.pulumi.azurenative.botservice.BotArgs.builder
import com.pulumi.azurenative.botservice.kotlin.enums.Kind
import com.pulumi.azurenative.botservice.kotlin.inputs.BotPropertiesArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.BotPropertiesArgsBuilder
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.botservice.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Bot resource definition
 * Azure REST API version: 2022-09-15. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### Create Bot
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bot = new AzureNative.BotService.Bot("bot", new()
 *     {
 *         Kind = "sdk",
 *         Location = "West US",
 *         Properties = new AzureNative.BotService.Inputs.BotPropertiesArgs
 *         {
 *             CmekKeyVaultUrl = "https://myCmekKey",
 *             Description = "The description of the bot",
 *             DeveloperAppInsightKey = "appinsightskey",
 *             DeveloperAppInsightsApiKey = "appinsightsapikey",
 *             DeveloperAppInsightsApplicationId = "appinsightsappid",
 *             DisableLocalAuth = true,
 *             DisplayName = "The Name of the bot",
 *             Endpoint = "http://mybot.coffee",
 *             IconUrl = "http://myicon",
 *             IsCmekEnabled = true,
 *             LuisAppIds = new[]
 *             {
 *                 "luisappid1",
 *                 "luisappid2",
 *             },
 *             LuisKey = "luiskey",
 *             MsaAppId = "exampleappid",
 *             MsaAppMSIResourceId = "/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId",
 *             MsaAppTenantId = "exampleapptenantid",
 *             MsaAppType = "UserAssignedMSI",
 *             PublicNetworkAccess = "Enabled",
 *             SchemaTransformationVersion = "1.0",
 *         },
 *         ResourceGroupName = "OneResourceGroupName",
 *         ResourceName = "samplebotname",
 *         Sku = new AzureNative.BotService.Inputs.SkuArgs
 *         {
 *             Name = "S1",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/botservice/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := botservice.NewBot(ctx, "bot", &botservice.BotArgs{
 * 			Kind:     pulumi.String("sdk"),
 * 			Location: pulumi.String("West US"),
 * 			Properties: &botservice.BotPropertiesArgs{
 * 				CmekKeyVaultUrl:                   pulumi.String("https://myCmekKey"),
 * 				Description:                       pulumi.String("The description of the bot"),
 * 				DeveloperAppInsightKey:            pulumi.String("appinsightskey"),
 * 				DeveloperAppInsightsApiKey:        pulumi.String("appinsightsapikey"),
 * 				DeveloperAppInsightsApplicationId: pulumi.String("appinsightsappid"),
 * 				DisableLocalAuth:                  pulumi.Bool(true),
 * 				DisplayName:                       pulumi.String("The Name of the bot"),
 * 				Endpoint:                          pulumi.String("http://mybot.coffee"),
 * 				IconUrl:                           pulumi.String("http://myicon"),
 * 				IsCmekEnabled:                     pulumi.Bool(true),
 * 				LuisAppIds: pulumi.StringArray{
 * 					pulumi.String("luisappid1"),
 * 					pulumi.String("luisappid2"),
 * 				},
 * 				LuisKey:                     pulumi.String("luiskey"),
 * 				MsaAppId:                    pulumi.String("exampleappid"),
 * 				MsaAppMSIResourceId:         pulumi.String("/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId"),
 * 				MsaAppTenantId:              pulumi.String("exampleapptenantid"),
 * 				MsaAppType:                  pulumi.String("UserAssignedMSI"),
 * 				PublicNetworkAccess:         pulumi.String("Enabled"),
 * 				SchemaTransformationVersion: pulumi.String("1.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("OneResourceGroupName"),
 * 			ResourceName:      pulumi.String("samplebotname"),
 * 			Sku: &botservice.SkuArgs{
 * 				Name: pulumi.String("S1"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.botservice.Bot;
 * import com.pulumi.azurenative.botservice.BotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bot = new Bot("bot", BotArgs.builder()
 *             .kind("sdk")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("cmekKeyVaultUrl", "https://myCmekKey"),
 *                 Map.entry("description", "The description of the bot"),
 *                 Map.entry("developerAppInsightKey", "appinsightskey"),
 *                 Map.entry("developerAppInsightsApiKey", "appinsightsapikey"),
 *                 Map.entry("developerAppInsightsApplicationId", "appinsightsappid"),
 *                 Map.entry("disableLocalAuth", true),
 *                 Map.entry("displayName", "The Name of the bot"),
 *                 Map.entry("endpoint", "http://mybot.coffee"),
 *                 Map.entry("iconUrl", "http://myicon"),
 *                 Map.entry("isCmekEnabled", true),
 *                 Map.entry("luisAppIds",
 *                     "luisappid1",
 *                     "luisappid2"),
 *                 Map.entry("luisKey", "luiskey"),
 *                 Map.entry("msaAppId", "exampleappid"),
 *                 Map.entry("msaAppMSIResourceId", "/subscriptions/foo/resourcegroups/bar/providers/microsoft.managedidentity/userassignedidentities/sampleId"),
 *                 Map.entry("msaAppTenantId", "exampleapptenantid"),
 *                 Map.entry("msaAppType", "UserAssignedMSI"),
 *                 Map.entry("publicNetworkAccess", "Enabled"),
 *                 Map.entry("schemaTransformationVersion", "1.0")
 *             ))
 *             .resourceGroupName("OneResourceGroupName")
 *             .resourceName("samplebotname")
 *             .sku(Map.of("name", "S1"))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:botservice:Bot samplebotname /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BotService/botServices/{resourceName}
 * ```
 * @property kind Required. Gets or sets the Kind of the resource.
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to bot resource
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property resourceName The name of the Bot resource.
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 */
public data class BotArgs(
    public val kind: Output<Either<String, Kind>>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<BotPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.BotArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.BotArgs =
        com.pulumi.azurenative.botservice.BotArgs.builder()
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BotArgs].
 */
@PulumiTagMarker
public class BotArgsBuilder internal constructor() {
    private var kind: Output<Either<String, Kind>>? = null

    private var location: Output<String>? = null

    private var properties: Output<BotPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("etgjfgnflypkqjva")
    public suspend fun kind(`value`: Output<Either<String, Kind>>) {
        this.kind = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("hrwjuedmsgjpcnmg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to bot resource
     */
    @JvmName("nlbwaysivhwmwuiv")
    public suspend fun properties(`value`: Output<BotPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("ctonmcalqtqaqgat")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("pdesnxgxctsgpupx")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("xekgloeplvgkbqbu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("abfuwcmaohcrwrkd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("xspygwmdwhdwjupr")
    public suspend fun kind(`value`: Either<String, Kind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("esbndewhgfxtofcj")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Required. Gets or sets the Kind of the resource.
     */
    @JvmName("pkbyjkpljspskcmx")
    public fun kind(`value`: Kind) {
        val toBeMapped = Either.ofRight<String, Kind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("uxbytfurmghdtvwp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to bot resource
     */
    @JvmName("kdgbryquhfsoyajq")
    public suspend fun properties(`value`: BotPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to bot resource
     */
    @JvmName("bdnnwmhjvghusdhl")
    public suspend fun properties(argument: suspend BotPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BotPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("nqmdatjdlrnpinha")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("yjcrctaoitwkuskn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Gets or sets the SKU of the resource.
     */
    @JvmName("bmyjhhhhkncxtvwi")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Gets or sets the SKU of the resource.
     */
    @JvmName("ijxrechnsvxewfxy")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Contains resource tags defined as key/value pairs.
     */
    @JvmName("bxobdiysgimbgvdd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Contains resource tags defined as key/value pairs.
     */
    @JvmName("mcwmnaqojqxvcsak")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BotArgs = BotArgs(
        kind = kind,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
    )
}
