@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.ConnectionSettingParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
 * @property key Key for the Connection Setting Parameter.
 * @property value Value associated with the Connection Setting Parameter.
 */
public data class ConnectionSettingParameterArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.ConnectionSettingParameterArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.ConnectionSettingParameterArgs =
        com.pulumi.azurenative.botservice.inputs.ConnectionSettingParameterArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionSettingParameterArgs].
 */
@PulumiTagMarker
public class ConnectionSettingParameterArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key for the Connection Setting Parameter.
     */
    @JvmName("qavqhsrtmhfkuvxi")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value associated with the Connection Setting Parameter.
     */
    @JvmName("skowoponjuiwifgt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key for the Connection Setting Parameter.
     */
    @JvmName("agfohefalxmntwra")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value associated with the Connection Setting Parameter.
     */
    @JvmName("eomlfvhpuqinwunn")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ConnectionSettingParameterArgs = ConnectionSettingParameterArgs(
        key = key,
        `value` = `value`,
    )
}
