@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.KikChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kik channel definition
 * @property channelName The channel name
 * Expected value is 'KikChannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property properties The set of properties specific to Kik channel resource
 */
public data class KikChannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<KikChannelPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.KikChannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.KikChannelArgs =
        com.pulumi.azurenative.botservice.inputs.KikChannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KikChannelArgs].
 */
@PulumiTagMarker
public class KikChannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<KikChannelPropertiesArgs>? = null

    /**
     * @param value The channel name
     * Expected value is 'KikChannel'.
     */
    @JvmName("aryeywrjnvviwesu")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("xtmocpmkeuwjbjuf")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("pneewrvdrbufpvrn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The set of properties specific to Kik channel resource
     */
    @JvmName("tgwnlsgysgtfbfav")
    public suspend fun properties(`value`: Output<KikChannelPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The channel name
     * Expected value is 'KikChannel'.
     */
    @JvmName("fivrqddgebfjjwef")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("hybtpfqfyldxnhmx")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("luamkgxgkgbivxgm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The set of properties specific to Kik channel resource
     */
    @JvmName("qinisicctwycwqhn")
    public suspend fun properties(`value`: KikChannelPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of properties specific to Kik channel resource
     */
    @JvmName("lokbogtsirsngnku")
    public suspend fun properties(argument: suspend KikChannelPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KikChannelPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): KikChannelArgs = KikChannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
        properties = properties,
    )
}
