@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.ListChannelWithKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property channelName The name of the Channel resource.
 * @property resourceGroupName The name of the Bot resource group in the user subscription.
 * @property resourceName The name of the Bot resource.
 */
public data class ListChannelWithKeysPlainArgs(
    public val channelName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.ListChannelWithKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.ListChannelWithKeysPlainArgs =
        com.pulumi.azurenative.botservice.inputs.ListChannelWithKeysPlainArgs.builder()
            .channelName(channelName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListChannelWithKeysPlainArgs].
 */
@PulumiTagMarker
public class ListChannelWithKeysPlainArgsBuilder internal constructor() {
    private var channelName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the Channel resource.
     */
    @JvmName("bsbtpqdyklygfyhp")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.channelName = mapped
    }

    /**
     * @param value The name of the Bot resource group in the user subscription.
     */
    @JvmName("cicwmytxbituqrot")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Bot resource.
     */
    @JvmName("olhvetupehknsgwr")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListChannelWithKeysPlainArgs = ListChannelWithKeysPlainArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
