@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.MsTeamsChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Microsoft Teams channel.
 * @property acceptedTerms Whether this channel accepted terms
 * @property callingWebhook Webhook for Microsoft Teams channel calls
 * @property deploymentEnvironment Deployment environment for Microsoft Teams channel calls
 * @property enableCalling Enable calling for Microsoft Teams channel
 * @property incomingCallRoute Webhook for Microsoft Teams channel calls
 * @property isEnabled Whether this channel is enabled for the bot
 */
public data class MsTeamsChannelPropertiesArgs(
    public val acceptedTerms: Output<Boolean>? = null,
    public val callingWebhook: Output<String>? = null,
    public val deploymentEnvironment: Output<String>? = null,
    public val enableCalling: Output<Boolean>? = null,
    public val incomingCallRoute: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.MsTeamsChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.MsTeamsChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.MsTeamsChannelPropertiesArgs.builder()
            .acceptedTerms(acceptedTerms?.applyValue({ args0 -> args0 }))
            .callingWebhook(callingWebhook?.applyValue({ args0 -> args0 }))
            .deploymentEnvironment(deploymentEnvironment?.applyValue({ args0 -> args0 }))
            .enableCalling(enableCalling?.applyValue({ args0 -> args0 }))
            .incomingCallRoute(incomingCallRoute?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MsTeamsChannelPropertiesArgs].
 */
@PulumiTagMarker
public class MsTeamsChannelPropertiesArgsBuilder internal constructor() {
    private var acceptedTerms: Output<Boolean>? = null

    private var callingWebhook: Output<String>? = null

    private var deploymentEnvironment: Output<String>? = null

    private var enableCalling: Output<Boolean>? = null

    private var incomingCallRoute: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value Whether this channel accepted terms
     */
    @JvmName("pedqinrhxxydyjyk")
    public suspend fun acceptedTerms(`value`: Output<Boolean>) {
        this.acceptedTerms = value
    }

    /**
     * @param value Webhook for Microsoft Teams channel calls
     */
    @JvmName("qmjcpkcibpbbefau")
    public suspend fun callingWebhook(`value`: Output<String>) {
        this.callingWebhook = value
    }

    /**
     * @param value Deployment environment for Microsoft Teams channel calls
     */
    @JvmName("fvtuoylvpucfokuc")
    public suspend fun deploymentEnvironment(`value`: Output<String>) {
        this.deploymentEnvironment = value
    }

    /**
     * @param value Enable calling for Microsoft Teams channel
     */
    @JvmName("kwjsniagmaichfov")
    public suspend fun enableCalling(`value`: Output<Boolean>) {
        this.enableCalling = value
    }

    /**
     * @param value Webhook for Microsoft Teams channel calls
     */
    @JvmName("plgpguaxpprorwkt")
    public suspend fun incomingCallRoute(`value`: Output<String>) {
        this.incomingCallRoute = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("dqpnylbagogeivex")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Whether this channel accepted terms
     */
    @JvmName("fxjukksoxwsnitpl")
    public suspend fun acceptedTerms(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceptedTerms = mapped
    }

    /**
     * @param value Webhook for Microsoft Teams channel calls
     */
    @JvmName("bsyqbdfasqoeqtua")
    public suspend fun callingWebhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.callingWebhook = mapped
    }

    /**
     * @param value Deployment environment for Microsoft Teams channel calls
     */
    @JvmName("vhrcyrfklawpjmsk")
    public suspend fun deploymentEnvironment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentEnvironment = mapped
    }

    /**
     * @param value Enable calling for Microsoft Teams channel
     */
    @JvmName("agwmynoexrcihohl")
    public suspend fun enableCalling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCalling = mapped
    }

    /**
     * @param value Webhook for Microsoft Teams channel calls
     */
    @JvmName("ddidcvhljjxkltgv")
    public suspend fun incomingCallRoute(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incomingCallRoute = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("yccqmxinhdgkeutp")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): MsTeamsChannelPropertiesArgs = MsTeamsChannelPropertiesArgs(
        acceptedTerms = acceptedTerms,
        callingWebhook = callingWebhook,
        deploymentEnvironment = deploymentEnvironment,
        enableCalling = enableCalling,
        incomingCallRoute = incomingCallRoute,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
    )
}
