@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.OmnichannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Omnichannel channel definition
 * @property channelName The channel name
 * Expected value is 'Omnichannel'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 */
public data class OmnichannelArgs(
    public val channelName: Output<String>,
    public val etag: Output<String>? = null,
    public val location: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.OmnichannelArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.OmnichannelArgs =
        com.pulumi.azurenative.botservice.inputs.OmnichannelArgs.builder()
            .channelName(channelName.applyValue({ args0 -> args0 }))
            .etag(etag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OmnichannelArgs].
 */
@PulumiTagMarker
public class OmnichannelArgsBuilder internal constructor() {
    private var channelName: Output<String>? = null

    private var etag: Output<String>? = null

    private var location: Output<String>? = null

    /**
     * @param value The channel name
     * Expected value is 'Omnichannel'.
     */
    @JvmName("bjfirqrclrjgfqer")
    public suspend fun channelName(`value`: Output<String>) {
        this.channelName = value
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("jidtulfgwkqoraij")
    public suspend fun etag(`value`: Output<String>) {
        this.etag = value
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("genbtuctvjdosmyt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The channel name
     * Expected value is 'Omnichannel'.
     */
    @JvmName("devjxglyxvafwagy")
    public suspend fun channelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.channelName = mapped
    }

    /**
     * @param value Entity Tag of the resource
     */
    @JvmName("bsnexkpqmlnxbjoy")
    public suspend fun etag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etag = mapped
    }

    /**
     * @param value Specifies the location of the resource.
     */
    @JvmName("llsfbyhscarrbbei")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    internal fun build(): OmnichannelArgs = OmnichannelArgs(
        channelName = channelName ?: throw PulumiNullFieldException("channelName"),
        etag = etag,
        location = location,
    )
}
