@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.SlackChannelPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The parameters to provide for the Slack channel.
 * @property clientId The Slack client id
 * @property clientSecret The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property isEnabled Whether this channel is enabled for the bot
 * @property landingPageUrl The Slack landing page Url
 * @property registerBeforeOAuthFlow Whether to register the settings before OAuth validation is performed. Recommended to True.
 * @property scopes The Slack permission scopes.
 * @property signingSecret The Slack signing secret.
 * @property verificationToken The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
 */
public data class SlackChannelPropertiesArgs(
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<String>? = null,
    public val isEnabled: Output<Boolean>,
    public val landingPageUrl: Output<String>? = null,
    public val registerBeforeOAuthFlow: Output<Boolean>? = null,
    public val scopes: Output<String>? = null,
    public val signingSecret: Output<String>? = null,
    public val verificationToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.SlackChannelPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.SlackChannelPropertiesArgs =
        com.pulumi.azurenative.botservice.inputs.SlackChannelPropertiesArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0 }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .landingPageUrl(landingPageUrl?.applyValue({ args0 -> args0 }))
            .registerBeforeOAuthFlow(registerBeforeOAuthFlow?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0 }))
            .signingSecret(signingSecret?.applyValue({ args0 -> args0 }))
            .verificationToken(verificationToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlackChannelPropertiesArgs].
 */
@PulumiTagMarker
public class SlackChannelPropertiesArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var clientSecret: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var landingPageUrl: Output<String>? = null

    private var registerBeforeOAuthFlow: Output<Boolean>? = null

    private var scopes: Output<String>? = null

    private var signingSecret: Output<String>? = null

    private var verificationToken: Output<String>? = null

    /**
     * @param value The Slack client id
     */
    @JvmName("xsuisddqglbyhfrh")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("ivfxwreuwofdggsf")
    public suspend fun clientSecret(`value`: Output<String>) {
        this.clientSecret = value
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("fcgjkpjdxhgqwnee")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The Slack landing page Url
     */
    @JvmName("gmdtpawlxwalymec")
    public suspend fun landingPageUrl(`value`: Output<String>) {
        this.landingPageUrl = value
    }

    /**
     * @param value Whether to register the settings before OAuth validation is performed. Recommended to True.
     */
    @JvmName("ibittjvudiaipxrb")
    public suspend fun registerBeforeOAuthFlow(`value`: Output<Boolean>) {
        this.registerBeforeOAuthFlow = value
    }

    /**
     * @param value The Slack permission scopes.
     */
    @JvmName("kgambnnwgoyjhklm")
    public suspend fun scopes(`value`: Output<String>) {
        this.scopes = value
    }

    /**
     * @param value The Slack signing secret.
     */
    @JvmName("snbvrlvajuaydsji")
    public suspend fun signingSecret(`value`: Output<String>) {
        this.signingSecret = value
    }

    /**
     * @param value The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("ecfiqwjnjrwtvwjb")
    public suspend fun verificationToken(`value`: Output<String>) {
        this.verificationToken = value
    }

    /**
     * @param value The Slack client id
     */
    @JvmName("gynnthrccauhwuxt")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("bpdoxxqpnkhnkdho")
    public suspend fun clientSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value Whether this channel is enabled for the bot
     */
    @JvmName("novdwvicqswyebfy")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The Slack landing page Url
     */
    @JvmName("hbsewtwmevwtlxsb")
    public suspend fun landingPageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.landingPageUrl = mapped
    }

    /**
     * @param value Whether to register the settings before OAuth validation is performed. Recommended to True.
     */
    @JvmName("xpdfsmwoanrlifps")
    public suspend fun registerBeforeOAuthFlow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registerBeforeOAuthFlow = mapped
    }

    /**
     * @param value The Slack permission scopes.
     */
    @JvmName("bwexxxffjvpbtryr")
    public suspend fun scopes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value The Slack signing secret.
     */
    @JvmName("rcfupbhofchqotrd")
    public suspend fun signingSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signingSecret = mapped
    }

    /**
     * @param value The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
     */
    @JvmName("wytdibliprqattgh")
    public suspend fun verificationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verificationToken = mapped
    }

    internal fun build(): SlackChannelPropertiesArgs = SlackChannelPropertiesArgs(
        clientId = clientId,
        clientSecret = clientSecret,
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        landingPageUrl = landingPageUrl,
        registerBeforeOAuthFlow = registerBeforeOAuthFlow,
        scopes = scopes,
        signingSecret = signingSecret,
        verificationToken = verificationToken,
    )
}
