@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.TelephonyChannelResourceApiConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A resource Api configuration for the Telephony channel
 * @property cognitiveServiceRegion The cognitive service region.
 * @property cognitiveServiceResourceId The cognitive service resourceId.
 * @property cognitiveServiceSubscriptionKey The cognitive service subscription key.
 * @property defaultLocale The default locale.
 * @property id The id of config.
 * @property providerName The provider name.
 */
public data class TelephonyChannelResourceApiConfigurationArgs(
    public val cognitiveServiceRegion: Output<String>? = null,
    public val cognitiveServiceResourceId: Output<String>? = null,
    public val cognitiveServiceSubscriptionKey: Output<String>? = null,
    public val defaultLocale: Output<String>? = null,
    public val id: Output<String>? = null,
    public val providerName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.TelephonyChannelResourceApiConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.botservice.inputs.TelephonyChannelResourceApiConfigurationArgs =
        com.pulumi.azurenative.botservice.inputs.TelephonyChannelResourceApiConfigurationArgs.builder()
            .cognitiveServiceRegion(cognitiveServiceRegion?.applyValue({ args0 -> args0 }))
            .cognitiveServiceResourceId(cognitiveServiceResourceId?.applyValue({ args0 -> args0 }))
            .cognitiveServiceSubscriptionKey(cognitiveServiceSubscriptionKey?.applyValue({ args0 -> args0 }))
            .defaultLocale(defaultLocale?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TelephonyChannelResourceApiConfigurationArgs].
 */
@PulumiTagMarker
public class TelephonyChannelResourceApiConfigurationArgsBuilder internal constructor() {
    private var cognitiveServiceRegion: Output<String>? = null

    private var cognitiveServiceResourceId: Output<String>? = null

    private var cognitiveServiceSubscriptionKey: Output<String>? = null

    private var defaultLocale: Output<String>? = null

    private var id: Output<String>? = null

    private var providerName: Output<String>? = null

    /**
     * @param value The cognitive service region.
     */
    @JvmName("juklewjiypowxctp")
    public suspend fun cognitiveServiceRegion(`value`: Output<String>) {
        this.cognitiveServiceRegion = value
    }

    /**
     * @param value The cognitive service resourceId.
     */
    @JvmName("gnwdlrbotpaiwlpt")
    public suspend fun cognitiveServiceResourceId(`value`: Output<String>) {
        this.cognitiveServiceResourceId = value
    }

    /**
     * @param value The cognitive service subscription key.
     */
    @JvmName("bmvgnjujssddxeft")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: Output<String>) {
        this.cognitiveServiceSubscriptionKey = value
    }

    /**
     * @param value The default locale.
     */
    @JvmName("tinfswixqsstgjhe")
    public suspend fun defaultLocale(`value`: Output<String>) {
        this.defaultLocale = value
    }

    /**
     * @param value The id of config.
     */
    @JvmName("ypjpcftleudvyeso")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The provider name.
     */
    @JvmName("emogllmpvvhqhiyp")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The cognitive service region.
     */
    @JvmName("eulmxnjctykbyuix")
    public suspend fun cognitiveServiceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceRegion = mapped
    }

    /**
     * @param value The cognitive service resourceId.
     */
    @JvmName("wgerqlquublubsww")
    public suspend fun cognitiveServiceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceResourceId = mapped
    }

    /**
     * @param value The cognitive service subscription key.
     */
    @JvmName("ymusogjapbwurfra")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceSubscriptionKey = mapped
    }

    /**
     * @param value The default locale.
     */
    @JvmName("mkbagbtrbapajpcx")
    public suspend fun defaultLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLocale = mapped
    }

    /**
     * @param value The id of config.
     */
    @JvmName("aowfqwtsbcmeefoh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The provider name.
     */
    @JvmName("ayqobhoxmgcdvwhy")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    internal fun build(): TelephonyChannelResourceApiConfigurationArgs =
        TelephonyChannelResourceApiConfigurationArgs(
            cognitiveServiceRegion = cognitiveServiceRegion,
            cognitiveServiceResourceId = cognitiveServiceResourceId,
            cognitiveServiceSubscriptionKey = cognitiveServiceSubscriptionKey,
            defaultLocale = defaultLocale,
            id = id,
            providerName = providerName,
        )
}
