@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.inputs

import com.pulumi.azurenative.botservice.inputs.TelephonyPhoneNumbersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A telephone number for the Telephony channel
 * @property acsEndpoint The endpoint of ACS.
 * @property acsResourceId The resource id of ACS.
 * @property acsSecret The secret of ACS.
 * @property cognitiveServiceRegion The service region of cognitive service.
 * @property cognitiveServiceResourceId The resource id of cognitive service.
 * @property cognitiveServiceSubscriptionKey The subscription key of cognitive service.
 * @property defaultLocale The default locale of the phone number.
 * @property id The element id.
 * @property offerType Optional Property that will determine the offering type of the phone.
 * @property phoneNumber The phone number.
 */
public data class TelephonyPhoneNumbersArgs(
    public val acsEndpoint: Output<String>? = null,
    public val acsResourceId: Output<String>? = null,
    public val acsSecret: Output<String>? = null,
    public val cognitiveServiceRegion: Output<String>? = null,
    public val cognitiveServiceResourceId: Output<String>? = null,
    public val cognitiveServiceSubscriptionKey: Output<String>? = null,
    public val defaultLocale: Output<String>? = null,
    public val id: Output<String>? = null,
    public val offerType: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.botservice.inputs.TelephonyPhoneNumbersArgs> {
    override fun toJava(): com.pulumi.azurenative.botservice.inputs.TelephonyPhoneNumbersArgs =
        com.pulumi.azurenative.botservice.inputs.TelephonyPhoneNumbersArgs.builder()
            .acsEndpoint(acsEndpoint?.applyValue({ args0 -> args0 }))
            .acsResourceId(acsResourceId?.applyValue({ args0 -> args0 }))
            .acsSecret(acsSecret?.applyValue({ args0 -> args0 }))
            .cognitiveServiceRegion(cognitiveServiceRegion?.applyValue({ args0 -> args0 }))
            .cognitiveServiceResourceId(cognitiveServiceResourceId?.applyValue({ args0 -> args0 }))
            .cognitiveServiceSubscriptionKey(cognitiveServiceSubscriptionKey?.applyValue({ args0 -> args0 }))
            .defaultLocale(defaultLocale?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .offerType(offerType?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TelephonyPhoneNumbersArgs].
 */
@PulumiTagMarker
public class TelephonyPhoneNumbersArgsBuilder internal constructor() {
    private var acsEndpoint: Output<String>? = null

    private var acsResourceId: Output<String>? = null

    private var acsSecret: Output<String>? = null

    private var cognitiveServiceRegion: Output<String>? = null

    private var cognitiveServiceResourceId: Output<String>? = null

    private var cognitiveServiceSubscriptionKey: Output<String>? = null

    private var defaultLocale: Output<String>? = null

    private var id: Output<String>? = null

    private var offerType: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    /**
     * @param value The endpoint of ACS.
     */
    @JvmName("ukwdhxeufgigvxos")
    public suspend fun acsEndpoint(`value`: Output<String>) {
        this.acsEndpoint = value
    }

    /**
     * @param value The resource id of ACS.
     */
    @JvmName("sittumsxdkghqhlx")
    public suspend fun acsResourceId(`value`: Output<String>) {
        this.acsResourceId = value
    }

    /**
     * @param value The secret of ACS.
     */
    @JvmName("dpvogduxvkhodxju")
    public suspend fun acsSecret(`value`: Output<String>) {
        this.acsSecret = value
    }

    /**
     * @param value The service region of cognitive service.
     */
    @JvmName("dfhakovoaoofkowp")
    public suspend fun cognitiveServiceRegion(`value`: Output<String>) {
        this.cognitiveServiceRegion = value
    }

    /**
     * @param value The resource id of cognitive service.
     */
    @JvmName("jpkhdsgpvuplhfnn")
    public suspend fun cognitiveServiceResourceId(`value`: Output<String>) {
        this.cognitiveServiceResourceId = value
    }

    /**
     * @param value The subscription key of cognitive service.
     */
    @JvmName("imfrjbcnkxputwuu")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: Output<String>) {
        this.cognitiveServiceSubscriptionKey = value
    }

    /**
     * @param value The default locale of the phone number.
     */
    @JvmName("jgfyvxccfrifltcc")
    public suspend fun defaultLocale(`value`: Output<String>) {
        this.defaultLocale = value
    }

    /**
     * @param value The element id.
     */
    @JvmName("neqoexeodscyumkg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Optional Property that will determine the offering type of the phone.
     */
    @JvmName("dfhnydwikhkdqgtq")
    public suspend fun offerType(`value`: Output<String>) {
        this.offerType = value
    }

    /**
     * @param value The phone number.
     */
    @JvmName("gmpflissxmsjfdic")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value The endpoint of ACS.
     */
    @JvmName("xrtkmucawjlmnicj")
    public suspend fun acsEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acsEndpoint = mapped
    }

    /**
     * @param value The resource id of ACS.
     */
    @JvmName("heodmxtwcytlxpvj")
    public suspend fun acsResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acsResourceId = mapped
    }

    /**
     * @param value The secret of ACS.
     */
    @JvmName("gjpnpumrnuvkedux")
    public suspend fun acsSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acsSecret = mapped
    }

    /**
     * @param value The service region of cognitive service.
     */
    @JvmName("afdmypdnhdvxssty")
    public suspend fun cognitiveServiceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceRegion = mapped
    }

    /**
     * @param value The resource id of cognitive service.
     */
    @JvmName("npafsldmqbxnetpe")
    public suspend fun cognitiveServiceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceResourceId = mapped
    }

    /**
     * @param value The subscription key of cognitive service.
     */
    @JvmName("edclyfmtaaucqntj")
    public suspend fun cognitiveServiceSubscriptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cognitiveServiceSubscriptionKey = mapped
    }

    /**
     * @param value The default locale of the phone number.
     */
    @JvmName("wpwlmacvlpcerpbr")
    public suspend fun defaultLocale(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLocale = mapped
    }

    /**
     * @param value The element id.
     */
    @JvmName("jbumfefdutlhewyo")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Optional Property that will determine the offering type of the phone.
     */
    @JvmName("pfwfbbhjyqolpolb")
    public suspend fun offerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offerType = mapped
    }

    /**
     * @param value The phone number.
     */
    @JvmName("uwcdibhxvoqfsabv")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): TelephonyPhoneNumbersArgs = TelephonyPhoneNumbersArgs(
        acsEndpoint = acsEndpoint,
        acsResourceId = acsResourceId,
        acsSecret = acsSecret,
        cognitiveServiceRegion = cognitiveServiceRegion,
        cognitiveServiceResourceId = cognitiveServiceResourceId,
        cognitiveServiceSubscriptionKey = cognitiveServiceSubscriptionKey,
        defaultLocale = defaultLocale,
        id = id,
        offerType = offerType,
        phoneNumber = phoneNumber,
    )
}
