@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The parameters to provide for the Email channel.
 * @property authMethod Email channel auth method. 0 Password (Default); 1 Graph.
 * @property emailAddress The email address
 * @property isEnabled Whether this channel is enabled for the bot
 * @property magicCode The magic code for setting up the modern authentication.
 * @property password The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
 */
public data class EmailChannelPropertiesResponse(
    public val authMethod: Double? = null,
    public val emailAddress: String,
    public val isEnabled: Boolean,
    public val magicCode: String? = null,
    public val password: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.EmailChannelPropertiesResponse):
            EmailChannelPropertiesResponse = EmailChannelPropertiesResponse(
            authMethod = javaType.authMethod().map({ args0 -> args0 }).orElse(null),
            emailAddress = javaType.emailAddress(),
            isEnabled = javaType.isEnabled(),
            magicCode = javaType.magicCode().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
        )
    }
}
