@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A Facebook page for Facebook channel registration
 * @property accessToken Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
 * @property id Page id
 */
public data class FacebookPageResponse(
    public val accessToken: String? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.FacebookPageResponse):
            FacebookPageResponse = FacebookPageResponse(
            accessToken = javaType.accessToken().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
        )
    }
}
