@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * M365 Extensions definition
 * @property channelName The channel name
 * Expected value is 'M365Extensions'.
 * @property etag Entity Tag of the resource
 * @property location Specifies the location of the resource.
 * @property provisioningState Provisioning state of the resource
 */
public data class M365ExtensionsResponse(
    public val channelName: String,
    public val etag: String? = null,
    public val location: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.M365ExtensionsResponse):
            M365ExtensionsResponse = M365ExtensionsResponse(
            channelName = javaType.channelName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
