@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.botservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A resource Api configuration for the Telephony channel
 * @property cognitiveServiceRegion The cognitive service region.
 * @property cognitiveServiceResourceId The cognitive service resourceId.
 * @property cognitiveServiceSubscriptionKey The cognitive service subscription key.
 * @property defaultLocale The default locale.
 * @property id The id of config.
 * @property providerName The provider name.
 */
public data class TelephonyChannelResourceApiConfigurationResponse(
    public val cognitiveServiceRegion: String? = null,
    public val cognitiveServiceResourceId: String? = null,
    public val cognitiveServiceSubscriptionKey: String? = null,
    public val defaultLocale: String? = null,
    public val id: String? = null,
    public val providerName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.botservice.outputs.TelephonyChannelResourceApiConfigurationResponse):
            TelephonyChannelResourceApiConfigurationResponse =
            TelephonyChannelResourceApiConfigurationResponse(
                cognitiveServiceRegion = javaType.cognitiveServiceRegion().map({ args0 -> args0 }).orElse(null),
                cognitiveServiceResourceId = javaType.cognitiveServiceResourceId().map({ args0 ->
                    args0
                }).orElse(null),
                cognitiveServiceSubscriptionKey = javaType.cognitiveServiceSubscriptionKey().map({ args0 ->
                    args0
                }).orElse(null),
                defaultLocale = javaType.defaultLocale().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                providerName = javaType.providerName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
