@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.LinkedServerArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.ReplicationRole
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Response to put/get linked server (with properties) for Redis cache.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-05-01-preview, 2023-08-01.
 * ## Example Usage
 * ### LinkedServer_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedServer = new AzureNative.Cache.LinkedServer("linkedServer", new()
 *     {
 *         LinkedRedisCacheId = "/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2",
 *         LinkedRedisCacheLocation = "West US",
 *         LinkedServerName = "cache2",
 *         Name = "cache1",
 *         ResourceGroupName = "rg1",
 *         ServerRole = AzureNative.Cache.ReplicationRole.Secondary,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewLinkedServer(ctx, "linkedServer", &cache.LinkedServerArgs{
 * 			LinkedRedisCacheId:       pulumi.String("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2"),
 * 			LinkedRedisCacheLocation: pulumi.String("West US"),
 * 			LinkedServerName:         pulumi.String("cache2"),
 * 			Name:                     pulumi.String("cache1"),
 * 			ResourceGroupName:        pulumi.String("rg1"),
 * 			ServerRole:               cache.ReplicationRoleSecondary,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.LinkedServer;
 * import com.pulumi.azurenative.cache.LinkedServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedServer = new LinkedServer("linkedServer", LinkedServerArgs.builder()
 *             .linkedRedisCacheId("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Cache/Redis/cache2")
 *             .linkedRedisCacheLocation("West US")
 *             .linkedServerName("cache2")
 *             .name("cache1")
 *             .resourceGroupName("rg1")
 *             .serverRole("Secondary")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:LinkedServer cache2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}/linkedServers/{linkedServerName}
 * ```
 * @property linkedRedisCacheId Fully qualified resourceId of the linked redis cache.
 * @property linkedRedisCacheLocation Location of the linked redis cache.
 * @property linkedServerName The name of the linked server that is being added to the Redis cache.
 * @property name The name of the Redis cache.
 * @property resourceGroupName The name of the resource group.
 * @property serverRole Role of the linked server.
 */
public data class LinkedServerArgs(
    public val linkedRedisCacheId: Output<String>? = null,
    public val linkedRedisCacheLocation: Output<String>? = null,
    public val linkedServerName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverRole: Output<ReplicationRole>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.LinkedServerArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.LinkedServerArgs =
        com.pulumi.azurenative.cache.LinkedServerArgs.builder()
            .linkedRedisCacheId(linkedRedisCacheId?.applyValue({ args0 -> args0 }))
            .linkedRedisCacheLocation(linkedRedisCacheLocation?.applyValue({ args0 -> args0 }))
            .linkedServerName(linkedServerName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverRole(serverRole?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LinkedServerArgs].
 */
@PulumiTagMarker
public class LinkedServerArgsBuilder internal constructor() {
    private var linkedRedisCacheId: Output<String>? = null

    private var linkedRedisCacheLocation: Output<String>? = null

    private var linkedServerName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverRole: Output<ReplicationRole>? = null

    /**
     * @param value Fully qualified resourceId of the linked redis cache.
     */
    @JvmName("tpplsdygjbsegenl")
    public suspend fun linkedRedisCacheId(`value`: Output<String>) {
        this.linkedRedisCacheId = value
    }

    /**
     * @param value Location of the linked redis cache.
     */
    @JvmName("kssqoedoxkginklt")
    public suspend fun linkedRedisCacheLocation(`value`: Output<String>) {
        this.linkedRedisCacheLocation = value
    }

    /**
     * @param value The name of the linked server that is being added to the Redis cache.
     */
    @JvmName("mxbkijaobgvtfehy")
    public suspend fun linkedServerName(`value`: Output<String>) {
        this.linkedServerName = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("siaahvygfoiygfaw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jjsiiijhyeqvbiqv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Role of the linked server.
     */
    @JvmName("jjdxedgofhjhwkix")
    public suspend fun serverRole(`value`: Output<ReplicationRole>) {
        this.serverRole = value
    }

    /**
     * @param value Fully qualified resourceId of the linked redis cache.
     */
    @JvmName("dtovotffkoamxbtq")
    public suspend fun linkedRedisCacheId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedRedisCacheId = mapped
    }

    /**
     * @param value Location of the linked redis cache.
     */
    @JvmName("fmkhiqdsdvornymu")
    public suspend fun linkedRedisCacheLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedRedisCacheLocation = mapped
    }

    /**
     * @param value The name of the linked server that is being added to the Redis cache.
     */
    @JvmName("hbidgbxmstdkynjt")
    public suspend fun linkedServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServerName = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("wiwgxampyxrqrfhk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("melppikuxjakgkhj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Role of the linked server.
     */
    @JvmName("yjnclbxxlhtfrqjc")
    public suspend fun serverRole(`value`: ReplicationRole?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverRole = mapped
    }

    internal fun build(): LinkedServerArgs = LinkedServerArgs(
        linkedRedisCacheId = linkedRedisCacheId,
        linkedRedisCacheLocation = linkedRedisCacheLocation,
        linkedServerName = linkedServerName,
        name = name,
        resourceGroupName = resourceGroupName,
        serverRole = serverRole,
    )
}
