@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin

import com.pulumi.azurenative.cache.RedisArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.cache.kotlin.enums.TlsVersion
import com.pulumi.azurenative.cache.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.cache.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.RedisCommonPropertiesRedisConfigurationArgs
import com.pulumi.azurenative.cache.kotlin.inputs.RedisCommonPropertiesRedisConfigurationArgsBuilder
import com.pulumi.azurenative.cache.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.cache.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A single Redis item in List or Get Operation.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2015-08-01, 2017-02-01, 2019-07-01, 2020-06-01, 2023-05-01-preview, 2023-08-01.
 * ## Example Usage
 * ### RedisCacheCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = "1.2",
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         RedisVersion = "4",
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = "P",
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String("1.2"),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			RedisVersion:       pulumi.String("4"),
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String("P"),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(Map.of("maxmemoryPolicy", "allkeys-lru"))
 *             .redisVersion("4")
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("family", "P"),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisCacheCreateDefaultVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = "1.2",
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = "P",
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String("1.2"),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String("P"),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(Map.of("maxmemoryPolicy", "allkeys-lru"))
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("family", "P"),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### RedisCacheCreateLatestVersion
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var redis = new AzureNative.Cache.Redis("redis", new()
 *     {
 *         EnableNonSslPort = true,
 *         Location = "West US",
 *         MinimumTlsVersion = "1.2",
 *         Name = "cache1",
 *         RedisConfiguration = new AzureNative.Cache.Inputs.RedisCommonPropertiesRedisConfigurationArgs
 *         {
 *             MaxmemoryPolicy = "allkeys-lru",
 *         },
 *         RedisVersion = "Latest",
 *         ReplicasPerPrimary = 2,
 *         ResourceGroupName = "rg1",
 *         ShardCount = 2,
 *         Sku = new AzureNative.Cache.Inputs.SkuArgs
 *         {
 *             Capacity = 1,
 *             Family = "P",
 *             Name = "Premium",
 *         },
 *         StaticIP = "192.168.0.5",
 *         SubnetId = "/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cache.NewRedis(ctx, "redis", &cache.RedisArgs{
 * 			EnableNonSslPort:  pulumi.Bool(true),
 * 			Location:          pulumi.String("West US"),
 * 			MinimumTlsVersion: pulumi.String("1.2"),
 * 			Name:              pulumi.String("cache1"),
 * 			RedisConfiguration: &cache.RedisCommonPropertiesRedisConfigurationArgs{
 * 				MaxmemoryPolicy: pulumi.String("allkeys-lru"),
 * 			},
 * 			RedisVersion:       pulumi.String("Latest"),
 * 			ReplicasPerPrimary: pulumi.Int(2),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			ShardCount:         pulumi.Int(2),
 * 			Sku: &cache.SkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Family:   pulumi.String("P"),
 * 				Name:     pulumi.String("Premium"),
 * 			},
 * 			StaticIP: pulumi.String("192.168.0.5"),
 * 			SubnetId: pulumi.String("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cache.Redis;
 * import com.pulumi.azurenative.cache.RedisArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var redis = new Redis("redis", RedisArgs.builder()
 *             .enableNonSslPort(true)
 *             .location("West US")
 *             .minimumTlsVersion("1.2")
 *             .name("cache1")
 *             .redisConfiguration(Map.of("maxmemoryPolicy", "allkeys-lru"))
 *             .redisVersion("Latest")
 *             .replicasPerPrimary(2)
 *             .resourceGroupName("rg1")
 *             .shardCount(2)
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("family", "P"),
 *                 Map.entry("name", "Premium")
 *             ))
 *             .staticIP("192.168.0.5")
 *             .subnetId("/subscriptions/subid/resourceGroups/rg2/providers/Microsoft.Network/virtualNetworks/network1/subnets/subnet1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cache:Redis cache1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redis/{name}
 * ```
 * @property enableNonSslPort Specifies whether the non-ssl Redis server port (6379) is enabled.
 * @property identity The identity of the resource.
 * @property location The geo-location where the resource lives
 * @property minimumTlsVersion Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
 * @property name The name of the Redis cache.
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
 * @property redisConfiguration All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
 * @property redisVersion Redis version. This should be in the form 'major[&#46;minor]' (only 'major' is required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
 * @property replicasPerMaster The number of replicas to be created per primary.
 * @property replicasPerPrimary The number of replicas to be created per primary.
 * @property resourceGroupName The name of the resource group.
 * @property shardCount The number of shards to be created on a Premium Cluster Cache.
 * @property sku The SKU of the Redis cache to deploy.
 * @property staticIP Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network; auto assigned by default.
 * @property subnetId The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
 * @property tags Resource tags.
 * @property tenantSettings A dictionary of tenant settings
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class RedisArgs(
    public val enableNonSslPort: Output<Boolean>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val minimumTlsVersion: Output<Either<String, TlsVersion>>? = null,
    public val name: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val redisConfiguration: Output<RedisCommonPropertiesRedisConfigurationArgs>? = null,
    public val redisVersion: Output<String>? = null,
    public val replicasPerMaster: Output<Int>? = null,
    public val replicasPerPrimary: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shardCount: Output<Int>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val staticIP: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenantSettings: Output<Map<String, String>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cache.RedisArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.RedisArgs =
        com.pulumi.azurenative.cache.RedisArgs.builder()
            .enableNonSslPort(enableNonSslPort?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .minimumTlsVersion(
                minimumTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .redisConfiguration(
                redisConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .redisVersion(redisVersion?.applyValue({ args0 -> args0 }))
            .replicasPerMaster(replicasPerMaster?.applyValue({ args0 -> args0 }))
            .replicasPerPrimary(replicasPerPrimary?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shardCount(shardCount?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .staticIP(staticIP?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenantSettings(
                tenantSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [RedisArgs].
 */
@PulumiTagMarker
public class RedisArgsBuilder internal constructor() {
    private var enableNonSslPort: Output<Boolean>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var minimumTlsVersion: Output<Either<String, TlsVersion>>? = null

    private var name: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var redisConfiguration: Output<RedisCommonPropertiesRedisConfigurationArgs>? = null

    private var redisVersion: Output<String>? = null

    private var replicasPerMaster: Output<Int>? = null

    private var replicasPerPrimary: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var shardCount: Output<Int>? = null

    private var sku: Output<SkuArgs>? = null

    private var staticIP: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenantSettings: Output<Map<String, String>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Specifies whether the non-ssl Redis server port (6379) is enabled.
     */
    @JvmName("ylrwjnjcdesetpeh")
    public suspend fun enableNonSslPort(`value`: Output<Boolean>) {
        this.enableNonSslPort = value
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("dikheptxvjinltye")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tshhsvfqfhgsceej")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    @JvmName("lbsepagbmepfkkan")
    public suspend fun minimumTlsVersion(`value`: Output<Either<String, TlsVersion>>) {
        this.minimumTlsVersion = value
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("bjijmoyvkfmfhmad")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
     */
    @JvmName("xwmvtibkmxfyjvgq")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
     */
    @JvmName("fercpqgwqfynomyy")
    public suspend
    fun redisConfiguration(`value`: Output<RedisCommonPropertiesRedisConfigurationArgs>) {
        this.redisConfiguration = value
    }

    /**
     * @param value Redis version. This should be in the form 'major[&#46;minor]' (only 'major' is required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
     */
    @JvmName("etfbnvjlwdcvmhup")
    public suspend fun redisVersion(`value`: Output<String>) {
        this.redisVersion = value
    }

    /**
     * @param value The number of replicas to be created per primary.
     */
    @JvmName("bupcychlrbwgwxcu")
    public suspend fun replicasPerMaster(`value`: Output<Int>) {
        this.replicasPerMaster = value
    }

    /**
     * @param value The number of replicas to be created per primary.
     */
    @JvmName("uyppnvvpkpyitmvn")
    public suspend fun replicasPerPrimary(`value`: Output<Int>) {
        this.replicasPerPrimary = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rwgsmbsbhcqkobje")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The number of shards to be created on a Premium Cluster Cache.
     */
    @JvmName("wpranxuqwtmussky")
    public suspend fun shardCount(`value`: Output<Int>) {
        this.shardCount = value
    }

    /**
     * @param value The SKU of the Redis cache to deploy.
     */
    @JvmName("vbbprifupphfmoyw")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network; auto assigned by default.
     */
    @JvmName("taquwsmxefaawgjm")
    public suspend fun staticIP(`value`: Output<String>) {
        this.staticIP = value
    }

    /**
     * @param value The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
     */
    @JvmName("ruqcjyrqgwdbquhi")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lxmnpoiychxvlpgc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A dictionary of tenant settings
     */
    @JvmName("sciraxihgviacnfs")
    public suspend fun tenantSettings(`value`: Output<Map<String, String>>) {
        this.tenantSettings = value
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("tdcaxuwwqlwjlfpq")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("lwthgdsnodgndyhq")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("frrhyvbcfdbiejvb")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Specifies whether the non-ssl Redis server port (6379) is enabled.
     */
    @JvmName("foeerleelwyfepsx")
    public suspend fun enableNonSslPort(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNonSslPort = mapped
    }

    /**
     * @param value The identity of the resource.
     */
    @JvmName("yfcsjyrrbhrjoegh")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the resource.
     */
    @JvmName("movoqrwwjwlencmb")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fqbaiuvmgyxnpywk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    @JvmName("akxqngkdivppqqmm")
    public suspend fun minimumTlsVersion(`value`: Either<String, TlsVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    @JvmName("pjxgilqqppgdpiko")
    public fun minimumTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value Optional: requires clients to use a specified TLS version (or higher) to connect (e,g, '1.0', '1.1', '1.2')
     */
    @JvmName("pvmrnlwmgtjerehv")
    public fun minimumTlsVersion(`value`: TlsVersion) {
        val toBeMapped = Either.ofRight<String, TlsVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimumTlsVersion = mapped
    }

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("ivlaaykfrmpkplrq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
     */
    @JvmName("aqwhqmehkoahdarn")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
     */
    @JvmName("ngtgslveoutshahm")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public endpoint access is allowed for this cache.  Value is optional, but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default value is 'Enabled'. Note: This setting is important for caches with private endpoints. It has *no effect* on caches that are joined to, or injected into, a virtual network subnet.
     */
    @JvmName("oxlyvvpmwipfyqnv")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
     */
    @JvmName("qpjrlssllrasgmue")
    public suspend fun redisConfiguration(`value`: RedisCommonPropertiesRedisConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redisConfiguration = mapped
    }

    /**
     * @param argument All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
     */
    @JvmName("aovcdhhqysaiokwa")
    public suspend
    fun redisConfiguration(argument: suspend RedisCommonPropertiesRedisConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RedisCommonPropertiesRedisConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redisConfiguration = mapped
    }

    /**
     * @param value Redis version. This should be in the form 'major[&#46;minor]' (only 'major' is required) or the value 'latest' which refers to the latest stable Redis version that is available. Supported versions: 4.0, 6.0 (latest). Default value is 'latest'.
     */
    @JvmName("uhbbafsuriajpbtp")
    public suspend fun redisVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redisVersion = mapped
    }

    /**
     * @param value The number of replicas to be created per primary.
     */
    @JvmName("faukqhlvrfeawklc")
    public suspend fun replicasPerMaster(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicasPerMaster = mapped
    }

    /**
     * @param value The number of replicas to be created per primary.
     */
    @JvmName("ertcxdwatlemvsxm")
    public suspend fun replicasPerPrimary(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicasPerPrimary = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qpvbadljpbapramo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of shards to be created on a Premium Cluster Cache.
     */
    @JvmName("neyohhewujxegfae")
    public suspend fun shardCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shardCount = mapped
    }

    /**
     * @param value The SKU of the Redis cache to deploy.
     */
    @JvmName("duuqcbbffyyeuwyi")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU of the Redis cache to deploy.
     */
    @JvmName("retdkjgwckgykbkn")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Static IP address. Optionally, may be specified when deploying a Redis cache inside an existing Azure Virtual Network; auto assigned by default.
     */
    @JvmName("geqgnrgyknoikqhy")
    public suspend fun staticIP(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticIP = mapped
    }

    /**
     * @param value The full resource ID of a subnet in a virtual network to deploy the Redis cache in. Example format: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/Microsoft.{Network|ClassicNetwork}/VirtualNetworks/vnet1/subnets/subnet1
     */
    @JvmName("onandoxtjixdtyln")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gipamutqyvyocirj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ytvqscpjhnagvujc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A dictionary of tenant settings
     */
    @JvmName("jvekugjysxdaqaux")
    public suspend fun tenantSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantSettings = mapped
    }

    /**
     * @param values A dictionary of tenant settings
     */
    @JvmName("hxefyyrurnjnnshp")
    public fun tenantSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenantSettings = mapped
    }

    /**
     * @param value A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("anyqxysmogqxxutn")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values A list of availability zones denoting where the resource needs to come from.
     */
    @JvmName("pqlgywpdbriyuoym")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): RedisArgs = RedisArgs(
        enableNonSslPort = enableNonSslPort,
        identity = identity,
        location = location,
        minimumTlsVersion = minimumTlsVersion,
        name = name,
        publicNetworkAccess = publicNetworkAccess,
        redisConfiguration = redisConfiguration,
        redisVersion = redisVersion,
        replicasPerMaster = replicasPerMaster,
        replicasPerPrimary = replicasPerPrimary,
        resourceGroupName = resourceGroupName,
        shardCount = shardCount,
        sku = sku,
        staticIP = staticIP,
        subnetId = subnetId,
        tags = tags,
        tenantSettings = tenantSettings,
        zones = zones,
    )
}
