@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Day of the week when a cache can be patched.
 */
public enum class DayOfWeek(
    public val javaValue: com.pulumi.azurenative.cache.enums.DayOfWeek,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.DayOfWeek> {
    Monday(com.pulumi.azurenative.cache.enums.DayOfWeek.Monday),
    Tuesday(com.pulumi.azurenative.cache.enums.DayOfWeek.Tuesday),
    Wednesday(com.pulumi.azurenative.cache.enums.DayOfWeek.Wednesday),
    Thursday(com.pulumi.azurenative.cache.enums.DayOfWeek.Thursday),
    Friday(com.pulumi.azurenative.cache.enums.DayOfWeek.Friday),
    Saturday(com.pulumi.azurenative.cache.enums.DayOfWeek.Saturday),
    Sunday(com.pulumi.azurenative.cache.enums.DayOfWeek.Sunday),
    Everyday(com.pulumi.azurenative.cache.enums.DayOfWeek.Everyday),
    Weekend(com.pulumi.azurenative.cache.enums.DayOfWeek.Weekend),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.DayOfWeek = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.DayOfWeek): DayOfWeek =
            DayOfWeek.values().first { it.javaValue == javaType }
    }
}
