@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The SKU family to use. Valid values: (C, P). (C = Basic/Standard, P = Premium).
 */
public enum class SkuFamily(
    public val javaValue: com.pulumi.azurenative.cache.enums.SkuFamily,
) : ConvertibleToJava<com.pulumi.azurenative.cache.enums.SkuFamily> {
    C(com.pulumi.azurenative.cache.enums.SkuFamily.C),
    P(com.pulumi.azurenative.cache.enums.SkuFamily.P),
    ;

    override fun toJava(): com.pulumi.azurenative.cache.enums.SkuFamily = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.enums.SkuFamily): SkuFamily =
            SkuFamily.values().first { it.javaValue == javaType }
    }
}
