@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ClusterPropertiesKeyEncryptionKeyIdentityArgs.builder
import com.pulumi.azurenative.cache.kotlin.enums.CmkIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property identityType Only userAssignedIdentity is supported in this API version; other types may be supported in the future
 * @property userAssignedIdentityResourceId User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
 */
public data class ClusterPropertiesKeyEncryptionKeyIdentityArgs(
    public val identityType: Output<Either<String, CmkIdentityType>>? = null,
    public val userAssignedIdentityResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ClusterPropertiesKeyEncryptionKeyIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.cache.inputs.ClusterPropertiesKeyEncryptionKeyIdentityArgs =
        com.pulumi.azurenative.cache.inputs.ClusterPropertiesKeyEncryptionKeyIdentityArgs.builder()
            .identityType(
                identityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .userAssignedIdentityResourceId(
                userAssignedIdentityResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ClusterPropertiesKeyEncryptionKeyIdentityArgs].
 */
@PulumiTagMarker
public class ClusterPropertiesKeyEncryptionKeyIdentityArgsBuilder internal constructor() {
    private var identityType: Output<Either<String, CmkIdentityType>>? = null

    private var userAssignedIdentityResourceId: Output<String>? = null

    /**
     * @param value Only userAssignedIdentity is supported in this API version; other types may be supported in the future
     */
    @JvmName("exjqmbeckmqcyhxf")
    public suspend fun identityType(`value`: Output<Either<String, CmkIdentityType>>) {
        this.identityType = value
    }

    /**
     * @param value User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
     */
    @JvmName("mkyporrkmpampbpe")
    public suspend fun userAssignedIdentityResourceId(`value`: Output<String>) {
        this.userAssignedIdentityResourceId = value
    }

    /**
     * @param value Only userAssignedIdentity is supported in this API version; other types may be supported in the future
     */
    @JvmName("pagmyulujkdlvakb")
    public suspend fun identityType(`value`: Either<String, CmkIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value Only userAssignedIdentity is supported in this API version; other types may be supported in the future
     */
    @JvmName("sdhwxasqkqdritsd")
    public fun identityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CmkIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value Only userAssignedIdentity is supported in this API version; other types may be supported in the future
     */
    @JvmName("sqxhoyrqrdjguola")
    public fun identityType(`value`: CmkIdentityType) {
        val toBeMapped = Either.ofRight<String, CmkIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value User assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/<sub uuid>/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId.
     */
    @JvmName("vccertkfqyidwjgd")
    public suspend fun userAssignedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityResourceId = mapped
    }

    internal fun build(): ClusterPropertiesKeyEncryptionKeyIdentityArgs =
        ClusterPropertiesKeyEncryptionKeyIdentityArgs(
            identityType = identityType,
            userAssignedIdentityResourceId = userAssignedIdentityResourceId,
        )
}
