@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.GetFirewallRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheName The name of the Redis cache.
 * @property resourceGroupName The name of the resource group.
 * @property ruleName The name of the firewall rule.
 */
public data class GetFirewallRulePlainArgs(
    public val cacheName: String,
    public val resourceGroupName: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.GetFirewallRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.GetFirewallRulePlainArgs =
        com.pulumi.azurenative.cache.inputs.GetFirewallRulePlainArgs.builder()
            .cacheName(cacheName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallRulePlainArgs].
 */
@PulumiTagMarker
public class GetFirewallRulePlainArgsBuilder internal constructor() {
    private var cacheName: String? = null

    private var resourceGroupName: String? = null

    private var ruleName: String? = null

    /**
     * @param value The name of the Redis cache.
     */
    @JvmName("pcurkwjkfyytejnh")
    public suspend fun cacheName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("fmxcvfvowsrhnhvt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("kuaruojuslkoipxj")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetFirewallRulePlainArgs = GetFirewallRulePlainArgs(
        cacheName = cacheName ?: throw PulumiNullFieldException("cacheName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
