@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.ModuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies configuration of a redis module
 * @property args Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
 * @property name The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
 */
public data class ModuleArgs(
    public val args: Output<String>? = null,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.cache.inputs.ModuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cache.inputs.ModuleArgs =
        com.pulumi.azurenative.cache.inputs.ModuleArgs.builder()
            .args(args?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModuleArgs].
 */
@PulumiTagMarker
public class ModuleArgsBuilder internal constructor() {
    private var args: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
     */
    @JvmName("wkvitsekgwnorhgi")
    public suspend fun args(`value`: Output<String>) {
        this.args = value
    }

    /**
     * @param value The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
     */
    @JvmName("mtmtxdixfsbhhldh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration options for the module, e.g. 'ERROR_RATE 0.01 INITIAL_SIZE 400'.
     */
    @JvmName("juljucdwcuwvcunj")
    public suspend fun args(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The name of the module, e.g. 'RedisBloom', 'RediSearch', 'RedisTimeSeries'
     */
    @JvmName("aebomttptlhmutil")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ModuleArgs = ModuleArgs(
        args = args,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
