@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.inputs

import com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * All Redis Settings. Few possible keys: rdb-backup-enabled,rdb-storage-connection-string,rdb-backup-frequency,maxmemory-delta,maxmemory-policy,notify-keyspace-events,maxmemory-samples,slowlog-log-slower-than,slowlog-max-len,list-max-ziplist-entries,list-max-ziplist-value,hash-max-ziplist-entries,hash-max-ziplist-value,set-max-intset-entries,zset-max-ziplist-entries,zset-max-ziplist-value etc.
 * @property aofBackupEnabled Specifies whether the aof backup is enabled
 * @property aofStorageConnectionString0 First storage account connection string
 * @property aofStorageConnectionString1 Second storage account connection string
 * @property authnotrequired Specifies whether the authentication is disabled. Setting this property is highly discouraged from security point of view.
 * @property maxfragmentationmemoryReserved Value in megabytes reserved for fragmentation per shard
 * @property maxmemoryDelta Value in megabytes reserved for non-cache usage per shard e.g. failover.
 * @property maxmemoryPolicy The eviction strategy used when your data won't fit within its memory limit.
 * @property maxmemoryReserved Value in megabytes reserved for non-cache usage per shard e.g. failover.
 * @property preferredDataPersistenceAuthMethod Preferred auth method to communicate to storage account used for data persistence, specify SAS or ManagedIdentity, default value is SAS
 * @property rdbBackupEnabled Specifies whether the rdb backup is enabled
 * @property rdbBackupFrequency Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
 * @property rdbBackupMaxSnapshotCount Specifies the maximum number of snapshots for rdb backup
 * @property rdbStorageConnectionString The storage account connection string for storing rdb file
 * @property storageSubscriptionId SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
 */
public data class RedisCommonPropertiesRedisConfigurationArgs(
    public val aofBackupEnabled: Output<String>? = null,
    public val aofStorageConnectionString0: Output<String>? = null,
    public val aofStorageConnectionString1: Output<String>? = null,
    public val authnotrequired: Output<String>? = null,
    public val maxfragmentationmemoryReserved: Output<String>? = null,
    public val maxmemoryDelta: Output<String>? = null,
    public val maxmemoryPolicy: Output<String>? = null,
    public val maxmemoryReserved: Output<String>? = null,
    public val preferredDataPersistenceAuthMethod: Output<String>? = null,
    public val rdbBackupEnabled: Output<String>? = null,
    public val rdbBackupFrequency: Output<String>? = null,
    public val rdbBackupMaxSnapshotCount: Output<String>? = null,
    public val rdbStorageConnectionString: Output<String>? = null,
    public val storageSubscriptionId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs =
        com.pulumi.azurenative.cache.inputs.RedisCommonPropertiesRedisConfigurationArgs.builder()
            .aofBackupEnabled(aofBackupEnabled?.applyValue({ args0 -> args0 }))
            .aofStorageConnectionString0(aofStorageConnectionString0?.applyValue({ args0 -> args0 }))
            .aofStorageConnectionString1(aofStorageConnectionString1?.applyValue({ args0 -> args0 }))
            .authnotrequired(authnotrequired?.applyValue({ args0 -> args0 }))
            .maxfragmentationmemoryReserved(maxfragmentationmemoryReserved?.applyValue({ args0 -> args0 }))
            .maxmemoryDelta(maxmemoryDelta?.applyValue({ args0 -> args0 }))
            .maxmemoryPolicy(maxmemoryPolicy?.applyValue({ args0 -> args0 }))
            .maxmemoryReserved(maxmemoryReserved?.applyValue({ args0 -> args0 }))
            .preferredDataPersistenceAuthMethod(
                preferredDataPersistenceAuthMethod?.applyValue({ args0 ->
                    args0
                }),
            )
            .rdbBackupEnabled(rdbBackupEnabled?.applyValue({ args0 -> args0 }))
            .rdbBackupFrequency(rdbBackupFrequency?.applyValue({ args0 -> args0 }))
            .rdbBackupMaxSnapshotCount(rdbBackupMaxSnapshotCount?.applyValue({ args0 -> args0 }))
            .rdbStorageConnectionString(rdbStorageConnectionString?.applyValue({ args0 -> args0 }))
            .storageSubscriptionId(storageSubscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RedisCommonPropertiesRedisConfigurationArgs].
 */
@PulumiTagMarker
public class RedisCommonPropertiesRedisConfigurationArgsBuilder internal constructor() {
    private var aofBackupEnabled: Output<String>? = null

    private var aofStorageConnectionString0: Output<String>? = null

    private var aofStorageConnectionString1: Output<String>? = null

    private var authnotrequired: Output<String>? = null

    private var maxfragmentationmemoryReserved: Output<String>? = null

    private var maxmemoryDelta: Output<String>? = null

    private var maxmemoryPolicy: Output<String>? = null

    private var maxmemoryReserved: Output<String>? = null

    private var preferredDataPersistenceAuthMethod: Output<String>? = null

    private var rdbBackupEnabled: Output<String>? = null

    private var rdbBackupFrequency: Output<String>? = null

    private var rdbBackupMaxSnapshotCount: Output<String>? = null

    private var rdbStorageConnectionString: Output<String>? = null

    private var storageSubscriptionId: Output<String>? = null

    /**
     * @param value Specifies whether the aof backup is enabled
     */
    @JvmName("xfckibgnrikdxcfs")
    public suspend fun aofBackupEnabled(`value`: Output<String>) {
        this.aofBackupEnabled = value
    }

    /**
     * @param value First storage account connection string
     */
    @JvmName("bsvjiricgqkqaymc")
    public suspend fun aofStorageConnectionString0(`value`: Output<String>) {
        this.aofStorageConnectionString0 = value
    }

    /**
     * @param value Second storage account connection string
     */
    @JvmName("twdjmirwsridhdqa")
    public suspend fun aofStorageConnectionString1(`value`: Output<String>) {
        this.aofStorageConnectionString1 = value
    }

    /**
     * @param value Specifies whether the authentication is disabled. Setting this property is highly discouraged from security point of view.
     */
    @JvmName("twodpibrnmtjjnkl")
    public suspend fun authnotrequired(`value`: Output<String>) {
        this.authnotrequired = value
    }

    /**
     * @param value Value in megabytes reserved for fragmentation per shard
     */
    @JvmName("tylakiwgbkvndvfi")
    public suspend fun maxfragmentationmemoryReserved(`value`: Output<String>) {
        this.maxfragmentationmemoryReserved = value
    }

    /**
     * @param value Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JvmName("fnyjpygelcgyttsj")
    public suspend fun maxmemoryDelta(`value`: Output<String>) {
        this.maxmemoryDelta = value
    }

    /**
     * @param value The eviction strategy used when your data won't fit within its memory limit.
     */
    @JvmName("tajqxklpcqblubor")
    public suspend fun maxmemoryPolicy(`value`: Output<String>) {
        this.maxmemoryPolicy = value
    }

    /**
     * @param value Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JvmName("gbctitcfokwnqolk")
    public suspend fun maxmemoryReserved(`value`: Output<String>) {
        this.maxmemoryReserved = value
    }

    /**
     * @param value Preferred auth method to communicate to storage account used for data persistence, specify SAS or ManagedIdentity, default value is SAS
     */
    @JvmName("jeacqmfbbxnphxex")
    public suspend fun preferredDataPersistenceAuthMethod(`value`: Output<String>) {
        this.preferredDataPersistenceAuthMethod = value
    }

    /**
     * @param value Specifies whether the rdb backup is enabled
     */
    @JvmName("idnfcnxryvyvxjpw")
    public suspend fun rdbBackupEnabled(`value`: Output<String>) {
        this.rdbBackupEnabled = value
    }

    /**
     * @param value Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
     */
    @JvmName("gbfxgfiosgnfqyut")
    public suspend fun rdbBackupFrequency(`value`: Output<String>) {
        this.rdbBackupFrequency = value
    }

    /**
     * @param value Specifies the maximum number of snapshots for rdb backup
     */
    @JvmName("cvjjbrtmjyswjstm")
    public suspend fun rdbBackupMaxSnapshotCount(`value`: Output<String>) {
        this.rdbBackupMaxSnapshotCount = value
    }

    /**
     * @param value The storage account connection string for storing rdb file
     */
    @JvmName("oajupyfrxwmsmlbk")
    public suspend fun rdbStorageConnectionString(`value`: Output<String>) {
        this.rdbStorageConnectionString = value
    }

    /**
     * @param value SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
     */
    @JvmName("ljyhlgyunypywdfo")
    public suspend fun storageSubscriptionId(`value`: Output<String>) {
        this.storageSubscriptionId = value
    }

    /**
     * @param value Specifies whether the aof backup is enabled
     */
    @JvmName("foakaookhqqhhwkv")
    public suspend fun aofBackupEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aofBackupEnabled = mapped
    }

    /**
     * @param value First storage account connection string
     */
    @JvmName("vgchdyxtpfcvsukn")
    public suspend fun aofStorageConnectionString0(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aofStorageConnectionString0 = mapped
    }

    /**
     * @param value Second storage account connection string
     */
    @JvmName("unkkntbtcrdokcum")
    public suspend fun aofStorageConnectionString1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aofStorageConnectionString1 = mapped
    }

    /**
     * @param value Specifies whether the authentication is disabled. Setting this property is highly discouraged from security point of view.
     */
    @JvmName("clribcyethjyaymg")
    public suspend fun authnotrequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authnotrequired = mapped
    }

    /**
     * @param value Value in megabytes reserved for fragmentation per shard
     */
    @JvmName("cfwqomcktdskcirx")
    public suspend fun maxfragmentationmemoryReserved(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxfragmentationmemoryReserved = mapped
    }

    /**
     * @param value Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JvmName("suyjkcxgplnwcyyk")
    public suspend fun maxmemoryDelta(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxmemoryDelta = mapped
    }

    /**
     * @param value The eviction strategy used when your data won't fit within its memory limit.
     */
    @JvmName("vkdlhatmruvtejqp")
    public suspend fun maxmemoryPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxmemoryPolicy = mapped
    }

    /**
     * @param value Value in megabytes reserved for non-cache usage per shard e.g. failover.
     */
    @JvmName("rhdjipohhhtsflqj")
    public suspend fun maxmemoryReserved(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxmemoryReserved = mapped
    }

    /**
     * @param value Preferred auth method to communicate to storage account used for data persistence, specify SAS or ManagedIdentity, default value is SAS
     */
    @JvmName("hejedivkotmolstk")
    public suspend fun preferredDataPersistenceAuthMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredDataPersistenceAuthMethod = mapped
    }

    /**
     * @param value Specifies whether the rdb backup is enabled
     */
    @JvmName("vbqrdekposflworj")
    public suspend fun rdbBackupEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbBackupEnabled = mapped
    }

    /**
     * @param value Specifies the frequency for creating rdb backup in minutes. Valid values: (15, 30, 60, 360, 720, 1440)
     */
    @JvmName("ccwlogfwjcljftxy")
    public suspend fun rdbBackupFrequency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbBackupFrequency = mapped
    }

    /**
     * @param value Specifies the maximum number of snapshots for rdb backup
     */
    @JvmName("wwrrdlyidtmscyyw")
    public suspend fun rdbBackupMaxSnapshotCount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbBackupMaxSnapshotCount = mapped
    }

    /**
     * @param value The storage account connection string for storing rdb file
     */
    @JvmName("msnmxhtirfkykgsr")
    public suspend fun rdbStorageConnectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rdbStorageConnectionString = mapped
    }

    /**
     * @param value SubscriptionId of the storage account for persistence (aof/rdb) using ManagedIdentity.
     */
    @JvmName("pgsoqksyinhxmsda")
    public suspend fun storageSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSubscriptionId = mapped
    }

    internal fun build(): RedisCommonPropertiesRedisConfigurationArgs =
        RedisCommonPropertiesRedisConfigurationArgs(
            aofBackupEnabled = aofBackupEnabled,
            aofStorageConnectionString0 = aofStorageConnectionString0,
            aofStorageConnectionString1 = aofStorageConnectionString1,
            authnotrequired = authnotrequired,
            maxfragmentationmemoryReserved = maxfragmentationmemoryReserved,
            maxmemoryDelta = maxmemoryDelta,
            maxmemoryPolicy = maxmemoryPolicy,
            maxmemoryReserved = maxmemoryReserved,
            preferredDataPersistenceAuthMethod = preferredDataPersistenceAuthMethod,
            rdbBackupEnabled = rdbBackupEnabled,
            rdbBackupFrequency = rdbBackupFrequency,
            rdbBackupMaxSnapshotCount = rdbBackupMaxSnapshotCount,
            rdbStorageConnectionString = rdbStorageConnectionString,
            storageSubscriptionId = storageSubscriptionId,
        )
}
