@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response to an operation on access policy assignment
 * @property accessPolicyName The name of the access policy that is being assigned
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property objectId Object Id to assign access policy to
 * @property objectIdAlias User friendly name for object id. Also represents username for token based authentication
 * @property provisioningState Provisioning state of an access policy assignment set
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAccessPolicyAssignmentResult(
    public val accessPolicyName: String,
    public val id: String,
    public val name: String,
    public val objectId: String,
    public val objectIdAlias: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.GetAccessPolicyAssignmentResult):
            GetAccessPolicyAssignmentResult = GetAccessPolicyAssignmentResult(
            accessPolicyName = javaType.accessPolicyName(),
            id = javaType.id(),
            name = javaType.name(),
            objectId = javaType.objectId(),
            objectIdAlias = javaType.objectIdAlias(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
