@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Patch schedule entry for a Premium Redis Cache.
 * @property dayOfWeek Day of the week when a cache can be patched.
 * @property maintenanceWindow ISO8601 timespan specifying how much time cache patching can take.
 * @property startHourUtc Start hour after which cache patching can start.
 */
public data class ScheduleEntryResponse(
    public val dayOfWeek: String,
    public val maintenanceWindow: String? = null,
    public val startHourUtc: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cache.outputs.ScheduleEntryResponse):
            ScheduleEntryResponse = ScheduleEntryResponse(
            dayOfWeek = javaType.dayOfWeek(),
            maintenanceWindow = javaType.maintenanceWindow().map({ args0 -> args0 }).orElse(null),
            startHourUtc = javaType.startHourUtc(),
        )
    }
}
