@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.AFDEndpointArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.AutoGeneratedDomainNameLabelScope
import com.pulumi.azurenative.cdn.kotlin.enums.EnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor endpoint uses the URL format <endpointname>.azureedge.net.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2020-09-01, 2023-07-01-preview.
 * ## Example Usage
 * ### AFDEndpoints_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var afdEndpoint = new AzureNative.Cdn.AFDEndpoint("afdEndpoint", new()
 *     {
 *         AutoGeneratedDomainNameLabelScope = "TenantReuse",
 *         EnabledState = "Enabled",
 *         EndpointName = "endpoint1",
 *         Location = "global",
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewAFDEndpoint(ctx, "afdEndpoint", &cdn.AFDEndpointArgs{
 * 			AutoGeneratedDomainNameLabelScope: pulumi.String("TenantReuse"),
 * 			EnabledState:                      pulumi.String("Enabled"),
 * 			EndpointName:                      pulumi.String("endpoint1"),
 * 			Location:                          pulumi.String("global"),
 * 			ProfileName:                       pulumi.String("profile1"),
 * 			ResourceGroupName:                 pulumi.String("RG"),
 * 			Tags:                              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.AFDEndpoint;
 * import com.pulumi.azurenative.cdn.AFDEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var afdEndpoint = new AFDEndpoint("afdEndpoint", AFDEndpointArgs.builder()
 *             .autoGeneratedDomainNameLabelScope("TenantReuse")
 *             .enabledState("Enabled")
 *             .endpointName("endpoint1")
 *             .location("global")
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:AFDEndpoint endpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/afdEndpoints/{endpointName}
 * ```
 * @property autoGeneratedDomainNameLabelScope Indicates the endpoint name reuse scope. The default value is TenantReuse.
 * @property enabledState Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 * @property endpointName Name of the endpoint under the profile which is unique globally.
 * @property location Resource location.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property tags Resource tags.
 */
public data class AFDEndpointArgs(
    public val autoGeneratedDomainNameLabelScope:
    Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null,
    public val enabledState: Output<Either<String, EnabledState>>? = null,
    public val endpointName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.AFDEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.AFDEndpointArgs =
        com.pulumi.azurenative.cdn.AFDEndpointArgs.builder()
            .autoGeneratedDomainNameLabelScope(
                autoGeneratedDomainNameLabelScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AFDEndpointArgs].
 */
@PulumiTagMarker
public class AFDEndpointArgsBuilder internal constructor() {
    private var autoGeneratedDomainNameLabelScope:
        Output<Either<String, AutoGeneratedDomainNameLabelScope>>? = null

    private var enabledState: Output<Either<String, EnabledState>>? = null

    private var endpointName: Output<String>? = null

    private var location: Output<String>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Indicates the endpoint name reuse scope. The default value is TenantReuse.
     */
    @JvmName("ftihptsaasadqgan")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Output<Either<String, AutoGeneratedDomainNameLabelScope>>) {
        this.autoGeneratedDomainNameLabelScope = value
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("wmmtupwxowsublex")
    public suspend fun enabledState(`value`: Output<Either<String, EnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("ccycpdhlsfelvpvy")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("xkculwqpnupephpl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("hupnmgxsdsjdnqjt")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("bktwuwjhoysjxpjr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("juecoskhjpgdcsfn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates the endpoint name reuse scope. The default value is TenantReuse.
     */
    @JvmName("ohubhfbbnwyewpsx")
    public suspend
    fun autoGeneratedDomainNameLabelScope(`value`: Either<String, AutoGeneratedDomainNameLabelScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Indicates the endpoint name reuse scope. The default value is TenantReuse.
     */
    @JvmName("bxumeqckonwggces")
    public fun autoGeneratedDomainNameLabelScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Indicates the endpoint name reuse scope. The default value is TenantReuse.
     */
    @JvmName("kxevjcnpkprxnikr")
    public fun autoGeneratedDomainNameLabelScope(`value`: AutoGeneratedDomainNameLabelScope) {
        val toBeMapped = Either.ofRight<String, AutoGeneratedDomainNameLabelScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.autoGeneratedDomainNameLabelScope = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("mwumnuorjwpahvqd")
    public suspend fun enabledState(`value`: Either<String, EnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("xybwfvprxigsujnm")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("vporgdhabqfhtygd")
    public fun enabledState(`value`: EnabledState) {
        val toBeMapped = Either.ofRight<String, EnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Name of the endpoint under the profile which is unique globally.
     */
    @JvmName("buaekcpibhcmpcvv")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("edtikxydpiseixbr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("niglsjbrjlhohoci")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("vxdjxicncqpayqbd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fjjamgrxolpevicn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ygjsnovlhioercot")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AFDEndpointArgs = AFDEndpointArgs(
        autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope,
        enabledState = enabledState,
        endpointName = endpointName,
        location = location,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
