@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin

import com.pulumi.azurenative.cdn.RuleArgs.builder
import com.pulumi.azurenative.cdn.kotlin.enums.MatchProcessingBehavior
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Friendly Rules name mapping to the any Rules or secret related information.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### Rules_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.Cdn.Rule("rule", new()
 *     {
 *         Actions = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeliveryRuleResponseHeaderActionArgs
 *             {
 *                 Name = "ModifyResponseHeader",
 *                 Parameters = new AzureNative.Cdn.Inputs.HeaderActionParametersArgs
 *                 {
 *                     HeaderAction = "Overwrite",
 *                     HeaderName = "X-CDN",
 *                     TypeName = "DeliveryRuleHeaderActionParameters",
 *                     Value = "MSFT",
 *                 },
 *             },
 *         },
 *         Conditions = new[]
 *         {
 *             new AzureNative.Cdn.Inputs.DeliveryRuleRequestMethodConditionArgs
 *             {
 *                 Name = "RequestMethod",
 *                 Parameters = new AzureNative.Cdn.Inputs.RequestMethodMatchConditionParametersArgs
 *                 {
 *                     MatchValues = new[]
 *                     {
 *                         "GET",
 *                     },
 *                     NegateCondition = false,
 *                     Operator = "Equal",
 *                     TypeName = "DeliveryRuleRequestMethodConditionParameters",
 *                 },
 *             },
 *         },
 *         Order = 1,
 *         ProfileName = "profile1",
 *         ResourceGroupName = "RG",
 *         RuleName = "rule1",
 *         RuleSetName = "ruleSet1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cdn/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cdn.NewRule(ctx, "rule", &cdn.RuleArgs{
 * 			Actions: pulumi.Array{
 * 				cdn.DeliveryRuleResponseHeaderAction{
 * 					Name: "ModifyResponseHeader",
 * 					Parameters: cdn.HeaderActionParameters{
 * 						HeaderAction: "Overwrite",
 * 						HeaderName:   "X-CDN",
 * 						TypeName:     "DeliveryRuleHeaderActionParameters",
 * 						Value:        "MSFT",
 * 					},
 * 				},
 * 			},
 * 			Conditions: pulumi.Array{
 * 				cdn.DeliveryRuleRequestMethodCondition{
 * 					Name: "RequestMethod",
 * 					Parameters: cdn.RequestMethodMatchConditionParameters{
 * 						MatchValues: []string{
 * 							"GET",
 * 						},
 * 						NegateCondition: false,
 * 						Operator:        "Equal",
 * 						TypeName:        "DeliveryRuleRequestMethodConditionParameters",
 * 					},
 * 				},
 * 			},
 * 			Order:             pulumi.Int(1),
 * 			ProfileName:       pulumi.String("profile1"),
 * 			ResourceGroupName: pulumi.String("RG"),
 * 			RuleName:          pulumi.String("rule1"),
 * 			RuleSetName:       pulumi.String("ruleSet1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cdn.Rule;
 * import com.pulumi.azurenative.cdn.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .actions(Map.ofEntries(
 *                 Map.entry("name", "ModifyResponseHeader"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("headerAction", "Overwrite"),
 *                     Map.entry("headerName", "X-CDN"),
 *                     Map.entry("typeName", "DeliveryRuleHeaderActionParameters"),
 *                     Map.entry("value", "MSFT")
 *                 ))
 *             ))
 *             .conditions(Map.ofEntries(
 *                 Map.entry("name", "RequestMethod"),
 *                 Map.entry("parameters", Map.ofEntries(
 *                     Map.entry("matchValues", "GET"),
 *                     Map.entry("negateCondition", false),
 *                     Map.entry("operator", "Equal"),
 *                     Map.entry("typeName", "DeliveryRuleRequestMethodConditionParameters")
 *                 ))
 *             ))
 *             .order(1)
 *             .profileName("profile1")
 *             .resourceGroupName("RG")
 *             .ruleName("rule1")
 *             .ruleSetName("ruleSet1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cdn:Rule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/ruleSets/{ruleSetName}/rules/{ruleName}
 * ```
 * @property actions A list of actions that are executed when all the conditions of a rule are satisfied.
 * @property conditions A list of conditions that must be matched for the actions to be executed
 * @property matchProcessingBehavior If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
 * @property order The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
 * @property profileName Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property ruleName Name of the delivery rule which is unique within the endpoint.
 * @property ruleSetName Name of the rule set under the profile.
 */
public data class RuleArgs(
    public val actions: Output<List<Any>>? = null,
    public val conditions: Output<List<Any>>? = null,
    public val matchProcessingBehavior: Output<Either<String, MatchProcessingBehavior>>? = null,
    public val order: Output<Int>? = null,
    public val profileName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val ruleSetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.RuleArgs> {
    override fun toJava(): com.pulumi.azurenative.cdn.RuleArgs =
        com.pulumi.azurenative.cdn.RuleArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .conditions(conditions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchProcessingBehavior(
                matchProcessingBehavior?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .order(order?.applyValue({ args0 -> args0 }))
            .profileName(profileName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .ruleSetName(ruleSetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var actions: Output<List<Any>>? = null

    private var conditions: Output<List<Any>>? = null

    private var matchProcessingBehavior: Output<Either<String, MatchProcessingBehavior>>? = null

    private var order: Output<Int>? = null

    private var profileName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var ruleSetName: Output<String>? = null

    /**
     * @param value A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("oopatddacbrowlyf")
    public suspend fun actions(`value`: Output<List<Any>>) {
        this.actions = value
    }

    @JvmName("ouivouhqbgylnqow")
    public suspend fun actions(vararg values: Output<Any>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("vlclsyuovglkqatj")
    public suspend fun actions(values: List<Output<Any>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("xvllaitjdoajcgkl")
    public suspend fun conditions(`value`: Output<List<Any>>) {
        this.conditions = value
    }

    @JvmName("vycivgjqmwsrhbpy")
    public suspend fun conditions(vararg values: Output<Any>) {
        this.conditions = Output.all(values.asList())
    }

    /**
     * @param values A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("vadnljubsqsvjyhf")
    public suspend fun conditions(values: List<Output<Any>>) {
        this.conditions = Output.all(values)
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("uhiuaclrcnhgnqxc")
    public suspend
    fun matchProcessingBehavior(`value`: Output<Either<String, MatchProcessingBehavior>>) {
        this.matchProcessingBehavior = value
    }

    /**
     * @param value The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
     */
    @JvmName("ecqvfymlnsgningu")
    public suspend fun order(`value`: Output<Int>) {
        this.order = value
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("jomntgjwaxlpwnsn")
    public suspend fun profileName(`value`: Output<String>) {
        this.profileName = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jmngidqjcuwmvbsf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the delivery rule which is unique within the endpoint.
     */
    @JvmName("kmcrmhswfdhxwvqm")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Name of the rule set under the profile.
     */
    @JvmName("ffttmtawkhlpecnq")
    public suspend fun ruleSetName(`value`: Output<String>) {
        this.ruleSetName = value
    }

    /**
     * @param value A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("rfxrxyydcipjfjeh")
    public suspend fun actions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values A list of actions that are executed when all the conditions of a rule are satisfied.
     */
    @JvmName("ugspeptsfngqsufn")
    public suspend fun actions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("eopbmocjgmsymdab")
    public suspend fun conditions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param values A list of conditions that must be matched for the actions to be executed
     */
    @JvmName("tlyojbtafcitfjdh")
    public suspend fun conditions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditions = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("yrefibjiyybrdfbx")
    public suspend fun matchProcessingBehavior(`value`: Either<String, MatchProcessingBehavior>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("qttuhscqsnykplip")
    public fun matchProcessingBehavior(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MatchProcessingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults to Continue.
     */
    @JvmName("aebptjvupadepsoe")
    public fun matchProcessingBehavior(`value`: MatchProcessingBehavior) {
        val toBeMapped = Either.ofRight<String, MatchProcessingBehavior>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchProcessingBehavior = mapped
    }

    /**
     * @param value The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
     */
    @JvmName("bhpptubvsxanuehq")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.order = mapped
    }

    /**
     * @param value Name of the Azure Front Door Standard or Azure Front Door Premium profile which is unique within the resource group.
     */
    @JvmName("uhjmvcrtxivayexg")
    public suspend fun profileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("paaxvorgvyxjguth")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the delivery rule which is unique within the endpoint.
     */
    @JvmName("sdewklxphbqoyhei")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Name of the rule set under the profile.
     */
    @JvmName("bxjcumuhsispmxaj")
    public suspend fun ruleSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleSetName = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        actions = actions,
        conditions = conditions,
        matchProcessingBehavior = matchProcessingBehavior,
        order = order,
        profileName = profileName,
        resourceGroupName = resourceGroupName,
        ruleName = ruleName,
        ruleSetName = ruleSetName,
    )
}
