@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what action to be applied when rule matches
 */
public enum class ActionType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.ActionType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.ActionType> {
    Allow(com.pulumi.azurenative.cdn.enums.ActionType.Allow),
    Block(com.pulumi.azurenative.cdn.enums.ActionType.Block),
    Log(com.pulumi.azurenative.cdn.enums.ActionType.Log),
    Redirect(com.pulumi.azurenative.cdn.enums.ActionType.Redirect),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.ActionType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.ActionType): ActionType =
            ActionType.values().first { it.javaValue == javaType }
    }
}
