@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Algorithm to use for URL signing
 */
public enum class Algorithm(
    public val javaValue: com.pulumi.azurenative.cdn.enums.Algorithm,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.Algorithm> {
    SHA256(com.pulumi.azurenative.cdn.enums.Algorithm.SHA256),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.Algorithm = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.Algorithm): Algorithm =
            Algorithm.values().first { it.javaValue == javaType }
    }
}
