@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The level at which the content needs to be cached.
 */
public enum class CacheType(
    public val javaValue: com.pulumi.azurenative.cdn.enums.CacheType,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.CacheType> {
    All(com.pulumi.azurenative.cdn.enums.CacheType.All),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.CacheType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.CacheType): CacheType =
            CacheType.values().first { it.javaValue == javaType }
    }
}
