@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cdn.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
 */
public enum class EnabledState(
    public val javaValue: com.pulumi.azurenative.cdn.enums.EnabledState,
) : ConvertibleToJava<com.pulumi.azurenative.cdn.enums.EnabledState> {
    Enabled(com.pulumi.azurenative.cdn.enums.EnabledState.Enabled),
    Disabled(com.pulumi.azurenative.cdn.enums.EnabledState.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.cdn.enums.EnabledState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.cdn.enums.EnabledState): EnabledState =
            EnabledState.values().first { it.javaValue == javaType }
    }
}
